/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tagEXCEPINFOPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tagEXCEPINFOPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tagEXCEPINFO.class)
public class tagEXCEPINFOPointer extends StructurePointer {

	// NULL
	public static final tagEXCEPINFOPointer NULL = new tagEXCEPINFOPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tagEXCEPINFOPointer(long address) {
		super(address);
	}

	public static tagEXCEPINFOPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tagEXCEPINFOPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tagEXCEPINFOPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tagEXCEPINFOPointer(address);
	}

	public tagEXCEPINFOPointer add(long count) {
		return tagEXCEPINFOPointer.cast(address + (tagEXCEPINFO.SIZEOF * count));
	}

	public tagEXCEPINFOPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tagEXCEPINFOPointer addOffset(long offset) {
		return tagEXCEPINFOPointer.cast(address + offset);
	}

	public tagEXCEPINFOPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tagEXCEPINFOPointer sub(long count) {
		return tagEXCEPINFOPointer.cast(address - (tagEXCEPINFO.SIZEOF * count));
	}

	public tagEXCEPINFOPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tagEXCEPINFOPointer subOffset(long offset) {
		return tagEXCEPINFOPointer.cast(address - offset);
	}

	public tagEXCEPINFOPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tagEXCEPINFOPointer untag(long mask) {
		return tagEXCEPINFOPointer.cast(address & ~mask);
	}

	public tagEXCEPINFOPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tagEXCEPINFO.SIZEOF;
	}

	// Implementation methods

	// U16* bstrDescription
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bstrDescriptionOffset_", declaredType="U16*")
	public U16Pointer bstrDescription() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagEXCEPINFO._bstrDescriptionOffset_));
	}

	// U16* bstrDescription
	public PointerPointer bstrDescriptionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagEXCEPINFO._bstrDescriptionOffset_));
	}

	// U16* bstrHelpFile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bstrHelpFileOffset_", declaredType="U16*")
	public U16Pointer bstrHelpFile() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagEXCEPINFO._bstrHelpFileOffset_));
	}

	// U16* bstrHelpFile
	public PointerPointer bstrHelpFileEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagEXCEPINFO._bstrHelpFileOffset_));
	}

	// U16* bstrSource
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bstrSourceOffset_", declaredType="U16*")
	public U16Pointer bstrSource() throws CorruptDataException {
		return U16Pointer.cast(getPointerAtOffset(tagEXCEPINFO._bstrSourceOffset_));
	}

	// U16* bstrSource
	public PointerPointer bstrSourceEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagEXCEPINFO._bstrSourceOffset_));
	}

	// U32 dwHelpContext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dwHelpContextOffset_", declaredType="U32")
	public UDATA dwHelpContext() throws CorruptDataException {
		return new U32(getIntAtOffset(tagEXCEPINFO._dwHelpContextOffset_));
	}

	// U32 dwHelpContext
	public UDATAPointer dwHelpContextEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(tagEXCEPINFO._dwHelpContextOffset_));
	}

	// void* pfnDeferredFillIn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfnDeferredFillInOffset_", declaredType="void*")
	public VoidPointer pfnDeferredFillIn() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tagEXCEPINFO._pfnDeferredFillInOffset_));
	}

	// void* pfnDeferredFillIn
	public PointerPointer pfnDeferredFillInEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagEXCEPINFO._pfnDeferredFillInOffset_));
	}

	// void* pvReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pvReservedOffset_", declaredType="void*")
	public VoidPointer pvReserved() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(tagEXCEPINFO._pvReservedOffset_));
	}

	// void* pvReserved
	public PointerPointer pvReservedEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(tagEXCEPINFO._pvReservedOffset_));
	}

	// I32 scode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scodeOffset_", declaredType="I32")
	public IDATA scode() throws CorruptDataException {
		return new I32(getIntAtOffset(tagEXCEPINFO._scodeOffset_));
	}

	// I32 scode
	public IDATAPointer scodeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(tagEXCEPINFO._scodeOffset_));
	}

	// U16 wCode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wCodeOffset_", declaredType="U16")
	public U16 wCode() throws CorruptDataException {
		return new U16(getShortAtOffset(tagEXCEPINFO._wCodeOffset_));
	}

	// U16 wCode
	public U16Pointer wCodeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagEXCEPINFO._wCodeOffset_));
	}

	// U16 wReserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wReservedOffset_", declaredType="U16")
	public U16 wReserved() throws CorruptDataException {
		return new U16(getShortAtOffset(tagEXCEPINFO._wReservedOffset_));
	}

	// U16 wReserved
	public U16Pointer wReservedEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(tagEXCEPINFO._wReservedOffset_));
	}

}
