/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9StackWalkState
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9StackWalkState {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9_STACKWALK_SLOT_TYPE_INTERNAL;
	public static final long J9_STACKWALK_SLOT_TYPE_JIT_REGISTER_MAP;
	public static final long J9_STACKWALK_SLOT_TYPE_JNI_LOCAL;
	public static final long J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
	public static final long J9_STACKWALK_SLOT_TYPE_PENDING;

	// Offsets

	public static final int _arg0EAOffset_;
	public static final int _argCountOffset_;
	public static final int _bpOffset_;
	public static final int _bytecodePCOffsetOffset_;
	public static final int _cacheOffset_;
	public static final int _cacheCursorOffset_;
	public static final int _constantPoolOffset_;
	public static final int _currentThreadOffset_;
	public static final int _decompilationRecordOffset_;
	public static final int _decompilationStackOffset_;
	public static final int _dropToCurrentFrameOffset_;
	public static final int _elsBitVectorOffset_;
	public static final int _flagsOffset_;
	public static final int _frameFlagsOffset_;
	public static final int _frameWalkFunctionOffset_;
	public static final int _framesWalkedOffset_;
	public static final int _i2jStateOffset_;
	public static final int _inlineDepthOffset_;
	public static final int _inlineMapOffset_;
	public static final int _inlinedCallSiteOffset_;
	public static final int _inlinerMapOffset_;
	public static final int _j2iFrameOffset_;
	public static final int _javaVMOffset_;
	public static final int _jitInfoOffset_;
	public static final int _linearSlotWalkerOffset_;
	public static final int _literalsOffset_;
	public static final int _loopBreakerOffset_;
	public static final int _maxFramesOffset_;
	public static final int _methodOffset_;
	public static final int _nextPCOffset_;
	public static final int _objectSlotBitVectorOffset_;
	public static final int _objectSlotWalkFunctionOffset_;
	public static final int _outgoingArgCountOffset_;
	public static final int _pcOffset_;
	public static final int _pcAddressOffset_;
	public static final int _previousOffset_;
	public static final int _previousFrameFlagsOffset_;
	public static final int _registerEAsOffset_;
	public static final int _resolveFrameFlagsOffset_;
	public static final int _restartExceptionOffset_;
	public static final int _restartPointOffset_;
	public static final int _returnAddressWalkFunctionOffset_;
	public static final int _savedObjectSlotWalkFunctionOffset_;
	public static final int _skipCountOffset_;
	public static final int _slotIndexOffset_;
	public static final int _slotTypeOffset_;
	public static final int _spOffset_;
	public static final int _stackMapOffset_;
	public static final int _unwindSPOffset_;
	public static final int _userData1Offset_;
	public static final int _userData2Offset_;
	public static final int _userData3Offset_;
	public static final int _userData4Offset_;
	public static final int _walkSPOffset_;
	public static final int _walkThreadOffset_;
	public static final int _walkedEntryLocalStorageOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9_STACKWALK_SLOT_TYPE_INTERNAL = 0;
		J9_STACKWALK_SLOT_TYPE_JIT_REGISTER_MAP = 0;
		J9_STACKWALK_SLOT_TYPE_JNI_LOCAL = 0;
		J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL = 0;
		J9_STACKWALK_SLOT_TYPE_PENDING = 0;
		_arg0EAOffset_ = 0;
		_argCountOffset_ = 0;
		_bpOffset_ = 0;
		_bytecodePCOffsetOffset_ = 0;
		_cacheOffset_ = 0;
		_cacheCursorOffset_ = 0;
		_constantPoolOffset_ = 0;
		_currentThreadOffset_ = 0;
		_decompilationRecordOffset_ = 0;
		_decompilationStackOffset_ = 0;
		_dropToCurrentFrameOffset_ = 0;
		_elsBitVectorOffset_ = 0;
		_flagsOffset_ = 0;
		_frameFlagsOffset_ = 0;
		_frameWalkFunctionOffset_ = 0;
		_framesWalkedOffset_ = 0;
		_i2jStateOffset_ = 0;
		_inlineDepthOffset_ = 0;
		_inlineMapOffset_ = 0;
		_inlinedCallSiteOffset_ = 0;
		_inlinerMapOffset_ = 0;
		_j2iFrameOffset_ = 0;
		_javaVMOffset_ = 0;
		_jitInfoOffset_ = 0;
		_linearSlotWalkerOffset_ = 0;
		_literalsOffset_ = 0;
		_loopBreakerOffset_ = 0;
		_maxFramesOffset_ = 0;
		_methodOffset_ = 0;
		_nextPCOffset_ = 0;
		_objectSlotBitVectorOffset_ = 0;
		_objectSlotWalkFunctionOffset_ = 0;
		_outgoingArgCountOffset_ = 0;
		_pcOffset_ = 0;
		_pcAddressOffset_ = 0;
		_previousOffset_ = 0;
		_previousFrameFlagsOffset_ = 0;
		_registerEAsOffset_ = 0;
		_resolveFrameFlagsOffset_ = 0;
		_restartExceptionOffset_ = 0;
		_restartPointOffset_ = 0;
		_returnAddressWalkFunctionOffset_ = 0;
		_savedObjectSlotWalkFunctionOffset_ = 0;
		_skipCountOffset_ = 0;
		_slotIndexOffset_ = 0;
		_slotTypeOffset_ = 0;
		_spOffset_ = 0;
		_stackMapOffset_ = 0;
		_unwindSPOffset_ = 0;
		_userData1Offset_ = 0;
		_userData2Offset_ = 0;
		_userData3Offset_ = 0;
		_userData4Offset_ = 0;
		_walkSPOffset_ = 0;
		_walkThreadOffset_ = 0;
		_walkedEntryLocalStorageOffset_ = 0;
	}

}
