/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: SunVMIPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the SunVMIPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=SunVMI.class)
public class SunVMIPointer extends StructurePointer {

	// NULL
	public static final SunVMIPointer NULL = new SunVMIPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected SunVMIPointer(long address) {
		super(address);
	}

	public static SunVMIPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static SunVMIPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static SunVMIPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new SunVMIPointer(address);
	}

	public SunVMIPointer add(long count) {
		return SunVMIPointer.cast(address + (SunVMI.SIZEOF * count));
	}

	public SunVMIPointer add(Scalar count) {
		return add(count.longValue());
	}

	public SunVMIPointer addOffset(long offset) {
		return SunVMIPointer.cast(address + offset);
	}

	public SunVMIPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public SunVMIPointer sub(long count) {
		return SunVMIPointer.cast(address - (SunVMI.SIZEOF * count));
	}

	public SunVMIPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public SunVMIPointer subOffset(long offset) {
		return SunVMIPointer.cast(address - offset);
	}

	public SunVMIPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public SunVMIPointer untag(long mask) {
		return SunVMIPointer.cast(address & ~mask);
	}

	public SunVMIPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return SunVMI.SIZEOF;
	}

	// Implementation methods

	// void* JVM_AllocateNewArray
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_AllocateNewArrayOffset_", declaredType="void*")
	public VoidPointer JVM_AllocateNewArray() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_AllocateNewArrayOffset_));
	}

	// void* JVM_AllocateNewArray
	public PointerPointer JVM_AllocateNewArrayEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_AllocateNewArrayOffset_));
	}

	// void* JVM_AllocateNewObject
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_AllocateNewObjectOffset_", declaredType="void*")
	public VoidPointer JVM_AllocateNewObject() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_AllocateNewObjectOffset_));
	}

	// void* JVM_AllocateNewObject
	public PointerPointer JVM_AllocateNewObjectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_AllocateNewObjectOffset_));
	}

	// void* JVM_ExtendBootClassPath
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_ExtendBootClassPathOffset_", declaredType="void*")
	public VoidPointer JVM_ExtendBootClassPath() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_ExtendBootClassPathOffset_));
	}

	// void* JVM_ExtendBootClassPath
	public PointerPointer JVM_ExtendBootClassPathEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_ExtendBootClassPathOffset_));
	}

	// void* JVM_FindClassFromClassLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_FindClassFromClassLoaderOffset_", declaredType="void*")
	public VoidPointer JVM_FindClassFromClassLoader() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_FindClassFromClassLoaderOffset_));
	}

	// void* JVM_FindClassFromClassLoader
	public PointerPointer JVM_FindClassFromClassLoaderEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_FindClassFromClassLoaderOffset_));
	}

	// void* JVM_FreeMemory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_FreeMemoryOffset_", declaredType="void*")
	public VoidPointer JVM_FreeMemory() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_FreeMemoryOffset_));
	}

	// void* JVM_FreeMemory
	public PointerPointer JVM_FreeMemoryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_FreeMemoryOffset_));
	}

	// void* JVM_GC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GCOffset_", declaredType="void*")
	public VoidPointer JVM_GC() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GCOffset_));
	}

	// void* JVM_GC
	public PointerPointer JVM_GCEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GCOffset_));
	}

	// void* JVM_GCNoCompact
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GCNoCompactOffset_", declaredType="void*")
	public VoidPointer JVM_GCNoCompact() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GCNoCompactOffset_));
	}

	// void* JVM_GCNoCompact
	public PointerPointer JVM_GCNoCompactEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GCNoCompactOffset_));
	}

	// void* JVM_GetCallerClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetCallerClassOffset_", declaredType="void*")
	public VoidPointer JVM_GetCallerClass() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetCallerClassOffset_));
	}

	// void* JVM_GetCallerClass
	public PointerPointer JVM_GetCallerClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetCallerClassOffset_));
	}

	// void* JVM_GetClassAccessFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetClassAccessFlagsOffset_", declaredType="void*")
	public VoidPointer JVM_GetClassAccessFlags() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetClassAccessFlagsOffset_));
	}

	// void* JVM_GetClassAccessFlags
	public PointerPointer JVM_GetClassAccessFlagsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetClassAccessFlagsOffset_));
	}

	// void* JVM_GetClassContext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetClassContextOffset_", declaredType="void*")
	public VoidPointer JVM_GetClassContext() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetClassContextOffset_));
	}

	// void* JVM_GetClassContext
	public PointerPointer JVM_GetClassContextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetClassContextOffset_));
	}

	// void* JVM_GetClassLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetClassLoaderOffset_", declaredType="void*")
	public VoidPointer JVM_GetClassLoader() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetClassLoaderOffset_));
	}

	// void* JVM_GetClassLoader
	public PointerPointer JVM_GetClassLoaderEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetClassLoaderOffset_));
	}

	// void* JVM_GetClassTypeAnnotations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetClassTypeAnnotationsOffset_", declaredType="void*")
	public VoidPointer JVM_GetClassTypeAnnotations() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetClassTypeAnnotationsOffset_));
	}

	// void* JVM_GetClassTypeAnnotations
	public PointerPointer JVM_GetClassTypeAnnotationsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetClassTypeAnnotationsOffset_));
	}

	// void* JVM_GetFieldTypeAnnotations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetFieldTypeAnnotationsOffset_", declaredType="void*")
	public VoidPointer JVM_GetFieldTypeAnnotations() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetFieldTypeAnnotationsOffset_));
	}

	// void* JVM_GetFieldTypeAnnotations
	public PointerPointer JVM_GetFieldTypeAnnotationsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetFieldTypeAnnotationsOffset_));
	}

	// void* JVM_GetMethodParameters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetMethodParametersOffset_", declaredType="void*")
	public VoidPointer JVM_GetMethodParameters() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetMethodParametersOffset_));
	}

	// void* JVM_GetMethodParameters
	public PointerPointer JVM_GetMethodParametersEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetMethodParametersOffset_));
	}

	// void* JVM_GetMethodTypeAnnotations
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetMethodTypeAnnotationsOffset_", declaredType="void*")
	public VoidPointer JVM_GetMethodTypeAnnotations() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetMethodTypeAnnotationsOffset_));
	}

	// void* JVM_GetMethodTypeAnnotations
	public PointerPointer JVM_GetMethodTypeAnnotationsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetMethodTypeAnnotationsOffset_));
	}

	// void* JVM_GetSystemPackage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetSystemPackageOffset_", declaredType="void*")
	public VoidPointer JVM_GetSystemPackage() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetSystemPackageOffset_));
	}

	// void* JVM_GetSystemPackage
	public PointerPointer JVM_GetSystemPackageEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetSystemPackageOffset_));
	}

	// void* JVM_GetSystemPackages
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetSystemPackagesOffset_", declaredType="void*")
	public VoidPointer JVM_GetSystemPackages() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetSystemPackagesOffset_));
	}

	// void* JVM_GetSystemPackages
	public PointerPointer JVM_GetSystemPackagesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetSystemPackagesOffset_));
	}

	// void* JVM_GetThreadInterruptEvent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_GetThreadInterruptEventOffset_", declaredType="void*")
	public VoidPointer JVM_GetThreadInterruptEvent() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_GetThreadInterruptEventOffset_));
	}

	// void* JVM_GetThreadInterruptEvent
	public PointerPointer JVM_GetThreadInterruptEventEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_GetThreadInterruptEventOffset_));
	}

	// void* JVM_Halt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_HaltOffset_", declaredType="void*")
	public VoidPointer JVM_Halt() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_HaltOffset_));
	}

	// void* JVM_Halt
	public PointerPointer JVM_HaltEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_HaltOffset_));
	}

	// void* JVM_InvokeMethod
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_InvokeMethodOffset_", declaredType="void*")
	public VoidPointer JVM_InvokeMethod() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_InvokeMethodOffset_));
	}

	// void* JVM_InvokeMethod
	public PointerPointer JVM_InvokeMethodEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_InvokeMethodOffset_));
	}

	// void* JVM_LatestUserDefinedLoader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_LatestUserDefinedLoaderOffset_", declaredType="void*")
	public VoidPointer JVM_LatestUserDefinedLoader() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_LatestUserDefinedLoaderOffset_));
	}

	// void* JVM_LatestUserDefinedLoader
	public PointerPointer JVM_LatestUserDefinedLoaderEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_LatestUserDefinedLoaderOffset_));
	}

	// void* JVM_MaxMemory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_MaxMemoryOffset_", declaredType="void*")
	public VoidPointer JVM_MaxMemory() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_MaxMemoryOffset_));
	}

	// void* JVM_MaxMemory
	public PointerPointer JVM_MaxMemoryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_MaxMemoryOffset_));
	}

	// void* JVM_MaxObjectInspectionAge
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_MaxObjectInspectionAgeOffset_", declaredType="void*")
	public VoidPointer JVM_MaxObjectInspectionAge() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_MaxObjectInspectionAgeOffset_));
	}

	// void* JVM_MaxObjectInspectionAge
	public PointerPointer JVM_MaxObjectInspectionAgeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_MaxObjectInspectionAgeOffset_));
	}

	// void* JVM_NewInstanceFromConstructor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_NewInstanceFromConstructorOffset_", declaredType="void*")
	public VoidPointer JVM_NewInstanceFromConstructor() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_NewInstanceFromConstructorOffset_));
	}

	// void* JVM_NewInstanceFromConstructor
	public PointerPointer JVM_NewInstanceFromConstructorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_NewInstanceFromConstructorOffset_));
	}

	// void* JVM_TotalMemory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVM_TotalMemoryOffset_", declaredType="void*")
	public VoidPointer JVM_TotalMemory() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(SunVMI._JVM_TotalMemoryOffset_));
	}

	// void* JVM_TotalMemory
	public PointerPointer JVM_TotalMemoryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(SunVMI._JVM_TotalMemoryOffset_));
	}

	// U64 reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reservedOffset_", declaredType="U64")
	public UDATA reserved() throws CorruptDataException {
		return new U64(getLongAtOffset(SunVMI._reservedOffset_));
	}

	// U64 reserved
	public UDATAPointer reservedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(SunVMI._reservedOffset_));
	}

}
