/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ArrayROMClasses
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ArrayROMClasses {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _booleanArrayClassNameOffset_;
	public static final int _booleanArrayROMClassOffset_;
	public static final int _byteArrayClassNameOffset_;
	public static final int _byteArrayROMClassOffset_;
	public static final int _charArrayClassNameOffset_;
	public static final int _charArrayROMClassOffset_;
	public static final int _cloneableClassNameOffset_;
	public static final int _doubleArrayClassNameOffset_;
	public static final int _doubleArrayROMClassOffset_;
	public static final int _floatArrayClassNameOffset_;
	public static final int _floatArrayROMClassOffset_;
	public static final int _headerOffset_;
	public static final int _intArrayClassNameOffset_;
	public static final int _intArrayROMClassOffset_;
	public static final int _interfaceClassesOffset_;
	public static final int _longArrayClassNameOffset_;
	public static final int _longArrayROMClassOffset_;
	public static final int _objectArrayClassNameOffset_;
	public static final int _objectArrayROMClassOffset_;
	public static final int _objectClassNameOffset_;
	public static final int _serializeableClassNameOffset_;
	public static final int _shortArrayClassNameOffset_;
	public static final int _shortArrayROMClassOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_booleanArrayClassNameOffset_ = 0;
		_booleanArrayROMClassOffset_ = 0;
		_byteArrayClassNameOffset_ = 0;
		_byteArrayROMClassOffset_ = 0;
		_charArrayClassNameOffset_ = 0;
		_charArrayROMClassOffset_ = 0;
		_cloneableClassNameOffset_ = 0;
		_doubleArrayClassNameOffset_ = 0;
		_doubleArrayROMClassOffset_ = 0;
		_floatArrayClassNameOffset_ = 0;
		_floatArrayROMClassOffset_ = 0;
		_headerOffset_ = 0;
		_intArrayClassNameOffset_ = 0;
		_intArrayROMClassOffset_ = 0;
		_interfaceClassesOffset_ = 0;
		_longArrayClassNameOffset_ = 0;
		_longArrayROMClassOffset_ = 0;
		_objectArrayClassNameOffset_ = 0;
		_objectArrayROMClassOffset_ = 0;
		_objectClassNameOffset_ = 0;
		_serializeableClassNameOffset_ = 0;
		_shortArrayClassNameOffset_ = 0;
		_shortArrayROMClassOffset_ = 0;
	}

}
