/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ConcurrentGC
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ConcurrentGC {

	// VM Constants

	public static final long SIZEOF;
	public static final long _conHelperCleanSize;
	public static final long _maxTraceSize;
	public static final long _meteringHistorySize;
	public static final long _minTraceSize;

	// Offsets

	public static final int __alloc2ConHelperTraceRateOffset_;
	public static final int __allocToInitRateOffset_;
	public static final int __allocToTraceRateOffset_;
	public static final int __allocToTraceRateMaxFactorOffset_;
	public static final int __allocToTraceRateMinFactorOffset_;
	public static final int __allocToTraceRateNormalOffset_;
	public static final int __callbackOffset_;
	public static final int __conHelperThreadsOffset_;
	public static final int __conHelpersActivationMonitorOffset_;
	public static final int __conHelpersRequestOffset_;
	public static final int __conHelpersShutdownCountOffset_;
	public static final int __conHelpersStartedOffset_;
	public static final int __conHelpersTableOffset_;
	public static final int __concurrentCycleStateOffset_;
	public static final int __concurrentDelegateOffset_;
	public static final int __concurrentPhaseStatsOffset_;
	public static final int __concurrentTuningMonitorOffset_;
	public static final int __currentMeteringHistoryOffset_;
	public static final int __forcedKickoffOffset_;
	public static final int __heapAllocOffset_;
	public static final int __heapBaseOffset_;
	public static final int __initRangesOffset_;
	public static final int __initSetupDoneOffset_;
	public static final int __initWorkCompleteMonitorOffset_;
	public static final int __initWorkMonitorOffset_;
	public static final int __initializeMarkMapOffset_;
	public static final int __initializersOffset_;
	public static final int __kickoffThresholdBufferOffset_;
	public static final int __languageKickoffReasonOffset_;
	public static final int __lastAverageAlloc2TraceRateOffset_;
	public static final int __lastConHelperTraceSizeCountOffset_;
	public static final int __lastFreeSizeOffset_;
	public static final int __lastTotalTracedOffset_;
	public static final int __maxAverageAlloc2TraceRateOffset_;
	public static final int __meteringHistoryOffset_;
	public static final int __meteringTypeOffset_;
	public static final int __nextInitRangeOffset_;
	public static final int __numInitRangesOffset_;
	public static final int __numPhysicalInitRangesOffset_;
	public static final int __rebuildInitWorkForAddOffset_;
	public static final int __rebuildInitWorkForRemoveOffset_;
	public static final int __retuneAfterHeapResizeOffset_;
	public static final int __statsOffset_;
	public static final int __tenureLiveObjectFactorOffset_;
	public static final int __tenureNonLeafObjectFactorOffset_;
	public static final int __tuningUpdateIntervalOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_conHelperCleanSize = 0;
		_maxTraceSize = 0;
		_meteringHistorySize = 0;
		_minTraceSize = 0;
		__alloc2ConHelperTraceRateOffset_ = 0;
		__allocToInitRateOffset_ = 0;
		__allocToTraceRateOffset_ = 0;
		__allocToTraceRateMaxFactorOffset_ = 0;
		__allocToTraceRateMinFactorOffset_ = 0;
		__allocToTraceRateNormalOffset_ = 0;
		__callbackOffset_ = 0;
		__conHelperThreadsOffset_ = 0;
		__conHelpersActivationMonitorOffset_ = 0;
		__conHelpersRequestOffset_ = 0;
		__conHelpersShutdownCountOffset_ = 0;
		__conHelpersStartedOffset_ = 0;
		__conHelpersTableOffset_ = 0;
		__concurrentCycleStateOffset_ = 0;
		__concurrentDelegateOffset_ = 0;
		__concurrentPhaseStatsOffset_ = 0;
		__concurrentTuningMonitorOffset_ = 0;
		__currentMeteringHistoryOffset_ = 0;
		__forcedKickoffOffset_ = 0;
		__heapAllocOffset_ = 0;
		__heapBaseOffset_ = 0;
		__initRangesOffset_ = 0;
		__initSetupDoneOffset_ = 0;
		__initWorkCompleteMonitorOffset_ = 0;
		__initWorkMonitorOffset_ = 0;
		__initializeMarkMapOffset_ = 0;
		__initializersOffset_ = 0;
		__kickoffThresholdBufferOffset_ = 0;
		__languageKickoffReasonOffset_ = 0;
		__lastAverageAlloc2TraceRateOffset_ = 0;
		__lastConHelperTraceSizeCountOffset_ = 0;
		__lastFreeSizeOffset_ = 0;
		__lastTotalTracedOffset_ = 0;
		__maxAverageAlloc2TraceRateOffset_ = 0;
		__meteringHistoryOffset_ = 0;
		__meteringTypeOffset_ = 0;
		__nextInitRangeOffset_ = 0;
		__numInitRangesOffset_ = 0;
		__numPhysicalInitRangesOffset_ = 0;
		__rebuildInitWorkForAddOffset_ = 0;
		__rebuildInitWorkForRemoveOffset_ = 0;
		__retuneAfterHeapResizeOffset_ = 0;
		__statsOffset_ = 0;
		__tenureLiveObjectFactorOffset_ = 0;
		__tenureNonLeafObjectFactorOffset_ = 0;
		__tuningUpdateIntervalOffset_ = 0;
	}

}
