/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: OMR_Agent$State
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class OMR_Agent$State {

	// VM Constants

	public static final long SIZEOF;
	public static final long INITIALIZED;
	public static final long LIBRARY_OPENED;
	public static final long LOOKUP_ONLOAD_ERROR;
	public static final long LOOKUP_ONUNLOAD_ERROR;
	public static final long ONLOAD_COMPLETED;
	public static final long ONLOAD_ERROR;
	public static final long ONUNLOAD_SUCCESS;
	public static final long OPEN_LIBRARY_ERROR;
	public static final long UNINITIALIZED;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		INITIALIZED = 0;
		LIBRARY_OPENED = 0;
		LOOKUP_ONLOAD_ERROR = 0;
		LOOKUP_ONUNLOAD_ERROR = 0;
		ONLOAD_COMPLETED = 0;
		ONLOAD_ERROR = 0;
		ONUNLOAD_SUCCESS = 0;
		OPEN_LIBRARY_ERROR = 0;
		UNINITIALIZED = 0;
	}

}
