/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _IMAGE_DOS_HEADER
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _IMAGE_DOS_HEADER {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _e_cblpOffset_;
	public static final int _e_cpOffset_;
	public static final int _e_cparhdrOffset_;
	public static final int _e_crlcOffset_;
	public static final int _e_csOffset_;
	public static final int _e_csumOffset_;
	public static final int _e_ipOffset_;
	public static final int _e_lfanewOffset_;
	public static final int _e_lfarlcOffset_;
	public static final int _e_magicOffset_;
	public static final int _e_maxallocOffset_;
	public static final int _e_minallocOffset_;
	public static final int _e_oemidOffset_;
	public static final int _e_oeminfoOffset_;
	public static final int _e_ovnoOffset_;
	public static final int _e_resOffset_;
	public static final int _e_res2Offset_;
	public static final int _e_spOffset_;
	public static final int _e_ssOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_e_cblpOffset_ = 0;
		_e_cpOffset_ = 0;
		_e_cparhdrOffset_ = 0;
		_e_crlcOffset_ = 0;
		_e_csOffset_ = 0;
		_e_csumOffset_ = 0;
		_e_ipOffset_ = 0;
		_e_lfanewOffset_ = 0;
		_e_lfarlcOffset_ = 0;
		_e_magicOffset_ = 0;
		_e_maxallocOffset_ = 0;
		_e_minallocOffset_ = 0;
		_e_oemidOffset_ = 0;
		_e_oeminfoOffset_ = 0;
		_e_ovnoOffset_ = 0;
		_e_resOffset_ = 0;
		_e_res2Offset_ = 0;
		_e_spOffset_ = 0;
		_e_ssOffset_ = 0;
	}

}
