/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9CfrError
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9CfrError {

	// VM Constants

	public static final long SIZEOF;
	public static final long CFR_NoAction;

	// Offsets

	public static final int _constantPoolOffset_;
	public static final int _errorActionOffset_;
	public static final int _errorBsmArgsIndexOffset_;
	public static final int _errorBsmIndexOffset_;
	public static final int _errorCPTypeOffset_;
	public static final int _errorCatalogOffset_;
	public static final int _errorCodeOffset_;
	public static final int _errorDataIndexOffset_;
	public static final int _errorFrameBCIOffset_;
	public static final int _errorFrameIndexOffset_;
	public static final int _errorMajorVersionOffset_;
	public static final int _errorMaxMajorVersionOffset_;
	public static final int _errorMemberOffset_;
	public static final int _errorMethodOffset_;
	public static final int _errorMinorVersionOffset_;
	public static final int _errorOffsetOffset_;
	public static final int _errorPCOffset_;
	public static final int _verboseErrorTypeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CFR_NoAction = 0;
		_constantPoolOffset_ = 0;
		_errorActionOffset_ = 0;
		_errorBsmArgsIndexOffset_ = 0;
		_errorBsmIndexOffset_ = 0;
		_errorCPTypeOffset_ = 0;
		_errorCatalogOffset_ = 0;
		_errorCodeOffset_ = 0;
		_errorDataIndexOffset_ = 0;
		_errorFrameBCIOffset_ = 0;
		_errorFrameIndexOffset_ = 0;
		_errorMajorVersionOffset_ = 0;
		_errorMaxMajorVersionOffset_ = 0;
		_errorMemberOffset_ = 0;
		_errorMethodOffset_ = 0;
		_errorMinorVersionOffset_ = 0;
		_errorOffsetOffset_ = 0;
		_errorPCOffset_ = 0;
		_verboseErrorTypeOffset_ = 0;
	}

}
