/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.test.lib.Asserts;
import jdk.test.lib.jfr.Events;

public class GCHelper {
    public static final String event_garbage_collection = "jdk.GarbageCollection";
    public static final String event_young_garbage_collection = "jdk.YoungGarbageCollection";
    public static final String event_old_garbage_collection = "jdk.OldGarbageCollection";
    public static final String event_parold_garbage_collection = "jdk.ParallelOldGarbageCollection";
    public static final String event_g1_garbage_collection = "jdk.G1GarbageCollection";
    public static final String event_heap_summary = "jdk.GCHeapSummary";
    public static final String event_heap_ps_summary = "jdk.PSHeapSummary";
    public static final String event_heap_metaspace_summary = "jdk.MetaspaceSummary";
    public static final String event_reference_statistics = "jdk.GCReferenceStatistics";
    public static final String event_phases_pause = "jdk.GCPhasePause";
    public static final String event_phases_level_1 = "jdk.GCPhasePauseLevel1";
    public static final String event_phases_level_2 = "jdk.GCPhasePauseLevel2";
    public static final String event_phases_level_3 = "jdk.GCPhasePauseLevel3";
    public static final String gcG1New = "G1New";
    public static final String gcDefNew = "DefNew";
    public static final String gcParallelScavenge = "ParallelScavenge";
    public static final String gcG1Old = "G1Old";
    public static final String gcG1Full = "G1Full";
    public static final String gcSerialOld = "SerialOld";
    public static final String gcPSMarkSweep = "PSMarkSweep";
    public static final String gcParallelOld = "ParallelOld";
    public static final String pauseLevelEvent = "GCPhasePauseLevel";
    private static final List<String> g1HeapRegionTypes;
    private static final List<String> shenandoahHeapRegionStates;
    private static PrintStream defaultErrorLog;
    public static Map<String, Boolean> beanCollectorTypes;
    public static Set<String> collectorOverrides;
    public static Map<String, String[]> requiredEvents;

    public static int getGcId(RecordedEvent event) {
        return (Integer)Events.assertField(event, "gcId").getValue();
    }

    public static boolean isGcEvent(RecordedEvent event) {
        for (ValueDescriptor v : event.getFields()) {
            if (!"gcId".equals(v.getName())) continue;
            return true;
        }
        return false;
    }

    public static RecordedEvent getConfigEvent(List<RecordedEvent> events) throws Exception {
        for (RecordedEvent event : events) {
            if (!"jdk.GCConfiguration".equals(event.getEventType().getName())) continue;
            return event;
        }
        Asserts.fail("Could not find event jdk.GCConfiguration");
        return null;
    }

    public static void callSystemGc(int num, boolean withGarbage) {
        for (int i = 0; i < num; ++i) {
            if (withGarbage) {
                GCHelper.makeGarbage();
            }
            System.gc();
        }
    }

    private static void makeGarbage() {
        Object[] garbage = new Object[1024];
        for (int i = 0; i < 1024; ++i) {
            garbage[i] = new Object();
        }
    }

    public static List<RecordedEvent> removeFirstAndLastGC(List<RecordedEvent> events) {
        int minGcId = Integer.MAX_VALUE;
        int maxGcId = Integer.MIN_VALUE;
        for (RecordedEvent event : events) {
            if (!Events.hasField(event, "gcId")) continue;
            int gcId = (Integer)Events.assertField(event, "gcId").getValue();
            minGcId = Math.min(gcId, minGcId);
            maxGcId = Math.max(gcId, maxGcId);
        }
        ArrayList<RecordedEvent> filteredEvents = new ArrayList<RecordedEvent>();
        for (RecordedEvent event : events) {
            int gcId;
            if (!Events.hasField(event, "gcId") || (gcId = ((Integer)Events.assertField(event, "gcId").getValue()).intValue()) == minGcId || gcId == maxGcId) continue;
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    public static PrintStream getDefaultErrorLog() {
        if (defaultErrorLog == null) {
            try {
                defaultErrorLog = new PrintStream(new FileOutputStream("error.log", true));
            }
            catch (IOException e) {
                e.printStackTrace();
                defaultErrorLog = System.err;
            }
        }
        return defaultErrorLog;
    }

    public static void log(Object msg) {
        GCHelper.log(msg, System.err);
        GCHelper.log(msg, GCHelper.getDefaultErrorLog());
    }

    public static void log(Object msg, PrintStream ps) {
        ps.println(msg);
    }

    public static boolean isValidG1HeapRegionType(String type) {
        return g1HeapRegionTypes.contains(type);
    }

    public static boolean assertIsValidShenandoahHeapRegionState(String state) {
        if (!shenandoahHeapRegionStates.contains(state)) {
            throw new AssertionError((Object)("Unknown state '" + state + "', valid heap region states are " + String.valueOf(shenandoahHeapRegionStates)));
        }
        return true;
    }

    public static long alignUp(long value, long alignment) {
        return value + alignment - 1L & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long alignDown(long value, long alignment) {
        return value & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static {
        defaultErrorLog = null;
        beanCollectorTypes = new HashMap<String, Boolean>();
        collectorOverrides = new HashSet<String>();
        requiredEvents = new HashMap<String, String[]>();
        beanCollectorTypes.put("G1 Young Generation", true);
        beanCollectorTypes.put("Copy", true);
        beanCollectorTypes.put("PS Scavenge", true);
        beanCollectorTypes.put("G1 Old Generation", false);
        beanCollectorTypes.put("G1 Concurrent GC", false);
        beanCollectorTypes.put("PS MarkSweep", false);
        beanCollectorTypes.put("MarkSweepCompact", false);
        collectorOverrides.add("G1Old.G1Full");
        collectorOverrides.add("SerialOld.PSMarkSweep");
        requiredEvents.put(gcG1New, new String[]{event_heap_summary, event_young_garbage_collection});
        requiredEvents.put(gcDefNew, new String[]{event_heap_summary, event_heap_metaspace_summary, event_phases_pause, event_phases_level_1, event_young_garbage_collection});
        requiredEvents.put(gcParallelScavenge, new String[]{event_heap_summary, event_heap_ps_summary, event_heap_metaspace_summary, event_reference_statistics, event_phases_pause, event_phases_level_1, event_young_garbage_collection});
        requiredEvents.put(gcG1Old, new String[]{event_heap_summary, event_old_garbage_collection});
        requiredEvents.put(gcG1Full, new String[]{event_heap_summary, event_heap_metaspace_summary, event_phases_pause, event_phases_level_1, event_old_garbage_collection});
        requiredEvents.put(gcSerialOld, new String[]{event_heap_summary, event_heap_metaspace_summary, event_phases_pause, event_phases_level_1, event_old_garbage_collection});
        requiredEvents.put(gcParallelOld, new String[]{event_heap_summary, event_heap_ps_summary, event_heap_metaspace_summary, event_reference_statistics, event_phases_pause, event_phases_level_1, event_old_garbage_collection, event_parold_garbage_collection});
        String[] g1HeapRegionTypeLiterals = new String[]{"Free", "Eden", "Survivor", "Starts Humongous", "Continues Humongous", "Old"};
        g1HeapRegionTypes = Collections.unmodifiableList(Arrays.asList(g1HeapRegionTypeLiterals));
        String[] shenandoahHeapRegionStateLiterals = new String[]{"Empty Uncommitted", "Empty Committed", "Regular", "Humongous Start", "Humongous Continuation", "Humongous Start, Pinned", "Collection Set", "Pinned", "Collection Set, Pinned", "Trash"};
        shenandoahHeapRegionStates = Collections.unmodifiableList(Arrays.asList(shenandoahHeapRegionStateLiterals));
    }

    public static class CollectionSummary {
        public long collectionCountOld;
        public long collectionCountYoung;
        public long collectionTimeOld;
        public long collectionTimeYoung;
        private Set<String> names = new HashSet<String>();

        public void add(String collectorName, boolean isYoung, long count, long time) {
            if (isYoung) {
                this.collectionCountYoung += count;
                this.collectionTimeYoung += time;
            } else {
                this.collectionCountOld += count;
                this.collectionTimeOld += time;
            }
            if (!this.names.contains(collectorName)) {
                this.names.add(collectorName);
            }
        }

        public long sum() {
            return this.collectionCountOld + this.collectionCountYoung;
        }

        public CollectionSummary calcDelta(CollectionSummary prev) {
            CollectionSummary delta = new CollectionSummary();
            delta.collectionCountOld = this.collectionCountOld - prev.collectionCountOld;
            delta.collectionTimeOld = this.collectionTimeOld - prev.collectionTimeOld;
            delta.collectionCountYoung = this.collectionCountYoung - prev.collectionCountYoung;
            delta.collectionTimeYoung = this.collectionTimeYoung - prev.collectionTimeYoung;
            delta.names.addAll(this.names);
            delta.names.addAll(prev.names);
            return delta;
        }

        public static CollectionSummary createFromMxBeans() {
            CollectionSummary summary = new CollectionSummary();
            List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (int c = 0; c < gcBeans.size(); ++c) {
                GarbageCollectorMXBean currBean = gcBeans.get(c);
                Boolean isYoung = beanCollectorTypes.get(currBean.getName());
                Asserts.assertNotNull(isYoung, "Unknown MXBean name: " + currBean.getName());
                long collectionTime = currBean.getCollectionTime() * 1000L;
                summary.add(currBean.getName(), isYoung, currBean.getCollectionCount(), collectionTime);
            }
            return summary;
        }

        public static CollectionSummary createFromEvents(List<GcBatch> batches) {
            CollectionSummary summary = new CollectionSummary();
            for (GcBatch batch : batches) {
                RecordedEvent endEvent = batch.getEndEvent();
                Asserts.assertNotNull(endEvent, "No end event in batch with gcId " + batch.getGcId());
                String name = batch.getName();
                summary.add(name, batch.isYoungCollection(), 1L, (Long)Events.assertField(endEvent, "sumOfPauses").getValue());
            }
            return summary;
        }

        public String toString() {
            StringBuilder collectorNames = new StringBuilder();
            for (String s : this.names) {
                if (collectorNames.length() > 0) {
                    collectorNames.append(", ");
                }
                collectorNames.append(s);
            }
            return String.format("CollectionSummary: young.collections=%d, young.time=%d, old.collections=%d, old.time=%d, collectors=(%s)", this.collectionCountYoung, this.collectionTimeYoung, this.collectionCountOld, this.collectionTimeOld, collectorNames);
        }
    }

    public static class GcBatch {
        private List<RecordedEvent> events = new ArrayList<RecordedEvent>();

        public int getGcId() {
            if (this.events.isEmpty()) {
                return -1;
            }
            return GCHelper.getGcId(this.events.get(0));
        }

        public String getName() {
            RecordedEvent endEvent = this.getEndEvent();
            String name = endEvent == null ? null : (String)Events.assertField(endEvent, "name").getValue();
            return name == null ? "null" : name;
        }

        public RecordedEvent getEndEvent() {
            return this.getEvent(GCHelper.event_garbage_collection);
        }

        public boolean addEvent(RecordedEvent event) {
            boolean isEndEvent;
            if (!this.events.isEmpty()) {
                Asserts.assertEquals(this.getGcId(), GCHelper.getGcId(event), "Wrong gcId in event. Error in test code.");
            }
            if (isEndEvent = GCHelper.event_garbage_collection.equals(event.getEventType().getName())) {
                Asserts.assertNull(this.getEndEvent(), String.format("Multiple %s for gcId %d", GCHelper.event_garbage_collection, this.getGcId()));
            }
            this.events.add(event);
            return isEndEvent;
        }

        public boolean isYoungCollection() {
            boolean isYoung = this.containsEvent(GCHelper.event_young_garbage_collection);
            boolean isOld = this.containsEvent(GCHelper.event_old_garbage_collection);
            Asserts.assertNotEquals(isYoung, isOld, "isYoung and isOld was same for batch: " + this.toString());
            return isYoung;
        }

        public int getEventCount() {
            return this.events.size();
        }

        public RecordedEvent getEvent(int index) {
            return this.events.get(index);
        }

        public List<RecordedEvent> getEvents() {
            return this.events;
        }

        public RecordedEvent getEvent(String eventPath) {
            for (RecordedEvent event : this.events) {
                if (!eventPath.equals(event.getEventType().getName())) continue;
                return event;
            }
            return null;
        }

        public boolean containsEvent(String eventPath) {
            return this.getEvent(eventPath) != null;
        }

        public String toString() {
            RecordedEvent endEvent = this.getEndEvent();
            Instant startTime = Instant.EPOCH;
            String cause = "?";
            String name = "?";
            if (endEvent != null) {
                name = this.getName();
                startTime = endEvent.getStartTime();
                cause = (String)Events.assertField(endEvent, "cause").getValue();
            }
            return String.format("GcEvent: gcId=%d, method=%s, cause=%s, startTime=%s", this.getGcId(), name, cause, startTime);
        }

        public String getLog() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString() + System.getProperty("line.separator"));
            for (RecordedEvent event : this.events) {
                sb.append(String.format("event: %s%n", event));
            }
            return sb.toString();
        }

        public static List<GcBatch> createFromEvents(List<RecordedEvent> events) throws Exception {
            Stack<Integer> openGcIds = new Stack<Integer>();
            ArrayList<GcBatch> batches = new ArrayList<GcBatch>();
            GcBatch currBatch = null;
            for (RecordedEvent event : events) {
                boolean isEndEvent;
                if (!GCHelper.isGcEvent(event)) continue;
                int gcId = GCHelper.getGcId(event);
                if (currBatch == null || currBatch.getGcId() != gcId) {
                    currBatch = null;
                    for (GcBatch loopBatch : batches) {
                        if (gcId != loopBatch.getGcId()) continue;
                        currBatch = loopBatch;
                        break;
                    }
                    if (currBatch == null) {
                        currBatch = new GcBatch();
                        batches.add(currBatch);
                        openGcIds.push(gcId);
                    }
                }
                if (!(isEndEvent = currBatch.addEvent(event))) continue;
                openGcIds.pop();
            }
            for (GcBatch batch : batches) {
                if (batch.getEndEvent() == null) {
                    System.out.println(batch.getLog());
                }
                Asserts.assertNotNull(batch.getEndEvent(), "GcBatch has no end event");
            }
            return batches;
        }
    }
}

