/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _aarch64_ctxPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _aarch64_ctxPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_aarch64_ctx.class)
public class _aarch64_ctxPointer extends StructurePointer {

	// NULL
	public static final _aarch64_ctxPointer NULL = new _aarch64_ctxPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _aarch64_ctxPointer(long address) {
		super(address);
	}

	public static _aarch64_ctxPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _aarch64_ctxPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _aarch64_ctxPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _aarch64_ctxPointer(address);
	}

	public _aarch64_ctxPointer add(long count) {
		return _aarch64_ctxPointer.cast(address + (_aarch64_ctx.SIZEOF * count));
	}

	public _aarch64_ctxPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _aarch64_ctxPointer addOffset(long offset) {
		return _aarch64_ctxPointer.cast(address + offset);
	}

	public _aarch64_ctxPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _aarch64_ctxPointer sub(long count) {
		return _aarch64_ctxPointer.cast(address - (_aarch64_ctx.SIZEOF * count));
	}

	public _aarch64_ctxPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _aarch64_ctxPointer subOffset(long offset) {
		return _aarch64_ctxPointer.cast(address - offset);
	}

	public _aarch64_ctxPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _aarch64_ctxPointer untag(long mask) {
		return _aarch64_ctxPointer.cast(address & ~mask);
	}

	public _aarch64_ctxPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _aarch64_ctx.SIZEOF;
	}

	// Implementation methods

	// __u32 magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_magicOffset_", declaredType="__u32")
	public UDATA magic() throws CorruptDataException {
		return new U32(getIntAtOffset(_aarch64_ctx._magicOffset_));
	}

	// __u32 magic
	public UDATAPointer magicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_aarch64_ctx._magicOffset_));
	}

	// __u32 size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sizeOffset_", declaredType="__u32")
	public UDATA size() throws CorruptDataException {
		return new U32(getIntAtOffset(_aarch64_ctx._sizeOffset_));
	}

	// __u32 size
	public UDATAPointer sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_aarch64_ctx._sizeOffset_));
	}

}
