/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9JSRICodeBlockPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9JSRICodeBlockPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9JSRICodeBlock.class)
public class J9JSRICodeBlockPointer extends StructurePointer {

	// NULL
	public static final J9JSRICodeBlockPointer NULL = new J9JSRICodeBlockPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9JSRICodeBlockPointer(long address) {
		super(address);
	}

	public static J9JSRICodeBlockPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9JSRICodeBlockPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9JSRICodeBlockPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9JSRICodeBlockPointer(address);
	}

	public J9JSRICodeBlockPointer add(long count) {
		return J9JSRICodeBlockPointer.cast(address + (J9JSRICodeBlock.SIZEOF * count));
	}

	public J9JSRICodeBlockPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9JSRICodeBlockPointer addOffset(long offset) {
		return J9JSRICodeBlockPointer.cast(address + offset);
	}

	public J9JSRICodeBlockPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9JSRICodeBlockPointer sub(long count) {
		return J9JSRICodeBlockPointer.cast(address - (J9JSRICodeBlock.SIZEOF * count));
	}

	public J9JSRICodeBlockPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9JSRICodeBlockPointer subOffset(long offset) {
		return J9JSRICodeBlockPointer.cast(address - offset);
	}

	public J9JSRICodeBlockPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9JSRICodeBlockPointer untag(long mask) {
		return J9JSRICodeBlockPointer.cast(address & ~mask);
	}

	public J9JSRICodeBlockPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9JSRICodeBlock.SIZEOF;
	}

	// Implementation methods

	// U32 coloured
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_colouredOffset_", declaredType="U32")
	public UDATA coloured() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JSRICodeBlock._colouredOffset_));
	}

	// U32 coloured
	public UDATAPointer colouredEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JSRICodeBlock._colouredOffset_));
	}

	// J9JSRIJSRData* jsrData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jsrDataOffset_", declaredType="J9JSRIJSRData*")
	public J9JSRIJSRDataPointer jsrData() throws CorruptDataException {
		return J9JSRIJSRDataPointer.cast(getPointerAtOffset(J9JSRICodeBlock._jsrDataOffset_));
	}

	// J9JSRIJSRData* jsrData
	public PointerPointer jsrDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9JSRICodeBlock._jsrDataOffset_));
	}

	// U32 length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lengthOffset_", declaredType="U32")
	public UDATA length() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JSRICodeBlock._lengthOffset_));
	}

	// U32 length
	public UDATAPointer lengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JSRICodeBlock._lengthOffset_));
	}

	// U32 newPC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_newPCOffset_", declaredType="U32")
	public UDATA newPC() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JSRICodeBlock._newPCOffset_));
	}

	// U32 newPC
	public UDATAPointer newPCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JSRICodeBlock._newPCOffset_));
	}

	// J9JSRICodeBlock* nextBlock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextBlockOffset_", declaredType="J9JSRICodeBlock*")
	public J9JSRICodeBlockPointer nextBlock() throws CorruptDataException {
		return J9JSRICodeBlockPointer.cast(getPointerAtOffset(J9JSRICodeBlock._nextBlockOffset_));
	}

	// J9JSRICodeBlock* nextBlock
	public PointerPointer nextBlockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9JSRICodeBlock._nextBlockOffset_));
	}

	// U32 originalPC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_originalPCOffset_", declaredType="U32")
	public UDATA originalPC() throws CorruptDataException {
		return new U32(getIntAtOffset(J9JSRICodeBlock._originalPCOffset_));
	}

	// U32 originalPC
	public UDATAPointer originalPCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9JSRICodeBlock._originalPCOffset_));
	}

	// J9JSRICodeBlock* primaryChild
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_primaryChildOffset_", declaredType="J9JSRICodeBlock*")
	public J9JSRICodeBlockPointer primaryChild() throws CorruptDataException {
		return J9JSRICodeBlockPointer.cast(getPointerAtOffset(J9JSRICodeBlock._primaryChildOffset_));
	}

	// J9JSRICodeBlock* primaryChild
	public PointerPointer primaryChildEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9JSRICodeBlock._primaryChildOffset_));
	}

	// J9JSRICodeBlock* secondaryChild
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_secondaryChildOffset_", declaredType="J9JSRICodeBlock*")
	public J9JSRICodeBlockPointer secondaryChild() throws CorruptDataException {
		return J9JSRICodeBlockPointer.cast(getPointerAtOffset(J9JSRICodeBlock._secondaryChildOffset_));
	}

	// J9JSRICodeBlock* secondaryChild
	public PointerPointer secondaryChildEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9JSRICodeBlock._secondaryChildOffset_));
	}

}
