/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_WriteOnceFixupCardCleanerPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_WriteOnceFixupCardCleanerPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_WriteOnceFixupCardCleaner.class)
public class MM_WriteOnceFixupCardCleanerPointer extends MM_CardCleanerPointer {

	// NULL
	public static final MM_WriteOnceFixupCardCleanerPointer NULL = new MM_WriteOnceFixupCardCleanerPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_WriteOnceFixupCardCleanerPointer(long address) {
		super(address);
	}

	public static MM_WriteOnceFixupCardCleanerPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_WriteOnceFixupCardCleanerPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_WriteOnceFixupCardCleanerPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_WriteOnceFixupCardCleanerPointer(address);
	}

	public MM_WriteOnceFixupCardCleanerPointer add(long count) {
		return MM_WriteOnceFixupCardCleanerPointer.cast(address + (MM_WriteOnceFixupCardCleaner.SIZEOF * count));
	}

	public MM_WriteOnceFixupCardCleanerPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_WriteOnceFixupCardCleanerPointer addOffset(long offset) {
		return MM_WriteOnceFixupCardCleanerPointer.cast(address + offset);
	}

	public MM_WriteOnceFixupCardCleanerPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_WriteOnceFixupCardCleanerPointer sub(long count) {
		return MM_WriteOnceFixupCardCleanerPointer.cast(address - (MM_WriteOnceFixupCardCleaner.SIZEOF * count));
	}

	public MM_WriteOnceFixupCardCleanerPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_WriteOnceFixupCardCleanerPointer subOffset(long offset) {
		return MM_WriteOnceFixupCardCleanerPointer.cast(address - offset);
	}

	public MM_WriteOnceFixupCardCleanerPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_WriteOnceFixupCardCleanerPointer untag(long mask) {
		return MM_WriteOnceFixupCardCleanerPointer.cast(address & ~mask);
	}

	public MM_WriteOnceFixupCardCleanerPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_WriteOnceFixupCardCleaner.SIZEOF;
	}

	// Implementation methods

	// const MM_WriteOnceCompactor* _compactScheme
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__compactSchemeOffset_", declaredType="const MM_WriteOnceCompactor*")
	public MM_WriteOnceCompactorPointer _compactScheme() throws CorruptDataException {
		return MM_WriteOnceCompactorPointer.cast(getPointerAtOffset(MM_WriteOnceFixupCardCleaner.__compactSchemeOffset_));
	}

	// const MM_WriteOnceCompactor* _compactScheme
	public PointerPointer _compactSchemeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_WriteOnceFixupCardCleaner.__compactSchemeOffset_));
	}

	// const bool _isGlobalMarkPhaseRunning
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__isGlobalMarkPhaseRunningOffset_", declaredType="const bool")
	public boolean _isGlobalMarkPhaseRunning() throws CorruptDataException {
		return getBoolAtOffset(MM_WriteOnceFixupCardCleaner.__isGlobalMarkPhaseRunningOffset_);
	}

	// const bool _isGlobalMarkPhaseRunning
	public BoolPointer _isGlobalMarkPhaseRunningEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_WriteOnceFixupCardCleaner.__isGlobalMarkPhaseRunningOffset_));
	}

	// const MM_HeapRegionManager* _regionManager
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__regionManagerOffset_", declaredType="const MM_HeapRegionManager*")
	public MM_HeapRegionManagerPointer _regionManager() throws CorruptDataException {
		return MM_HeapRegionManagerPointer.cast(getPointerAtOffset(MM_WriteOnceFixupCardCleaner.__regionManagerOffset_));
	}

	// const MM_HeapRegionManager* _regionManager
	public PointerPointer _regionManagerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_WriteOnceFixupCardCleaner.__regionManagerOffset_));
	}

}
