/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OMRCgroupMemoryInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OMRCgroupMemoryInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OMRCgroupMemoryInfo.class)
public class OMRCgroupMemoryInfoPointer extends StructurePointer {

	// NULL
	public static final OMRCgroupMemoryInfoPointer NULL = new OMRCgroupMemoryInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OMRCgroupMemoryInfoPointer(long address) {
		super(address);
	}

	public static OMRCgroupMemoryInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OMRCgroupMemoryInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OMRCgroupMemoryInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new OMRCgroupMemoryInfoPointer(address);
	}

	public OMRCgroupMemoryInfoPointer add(long count) {
		return OMRCgroupMemoryInfoPointer.cast(address + (OMRCgroupMemoryInfo.SIZEOF * count));
	}

	public OMRCgroupMemoryInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public OMRCgroupMemoryInfoPointer addOffset(long offset) {
		return OMRCgroupMemoryInfoPointer.cast(address + offset);
	}

	public OMRCgroupMemoryInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OMRCgroupMemoryInfoPointer sub(long count) {
		return OMRCgroupMemoryInfoPointer.cast(address - (OMRCgroupMemoryInfo.SIZEOF * count));
	}

	public OMRCgroupMemoryInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OMRCgroupMemoryInfoPointer subOffset(long offset) {
		return OMRCgroupMemoryInfoPointer.cast(address - offset);
	}

	public OMRCgroupMemoryInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OMRCgroupMemoryInfoPointer untag(long mask) {
		return OMRCgroupMemoryInfoPointer.cast(address & ~mask);
	}

	public OMRCgroupMemoryInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OMRCgroupMemoryInfo.SIZEOF;
	}

	// Implementation methods

	// U64 cached
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cachedOffset_", declaredType="U64")
	public UDATA cached() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMemoryInfo._cachedOffset_));
	}

	// U64 cached
	public UDATAPointer cachedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupMemoryInfo._cachedOffset_));
	}

	// U64 memoryAndSwapLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memoryAndSwapLimitOffset_", declaredType="U64")
	public UDATA memoryAndSwapLimit() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMemoryInfo._memoryAndSwapLimitOffset_));
	}

	// U64 memoryAndSwapLimit
	public UDATAPointer memoryAndSwapLimitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupMemoryInfo._memoryAndSwapLimitOffset_));
	}

	// U64 memoryAndSwapUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memoryAndSwapUsageOffset_", declaredType="U64")
	public UDATA memoryAndSwapUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMemoryInfo._memoryAndSwapUsageOffset_));
	}

	// U64 memoryAndSwapUsage
	public UDATAPointer memoryAndSwapUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupMemoryInfo._memoryAndSwapUsageOffset_));
	}

	// U64 memoryLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memoryLimitOffset_", declaredType="U64")
	public UDATA memoryLimit() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMemoryInfo._memoryLimitOffset_));
	}

	// U64 memoryLimit
	public UDATAPointer memoryLimitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupMemoryInfo._memoryLimitOffset_));
	}

	// U64 memoryUsage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memoryUsageOffset_", declaredType="U64")
	public UDATA memoryUsage() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMemoryInfo._memoryUsageOffset_));
	}

	// U64 memoryUsage
	public UDATAPointer memoryUsageEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupMemoryInfo._memoryUsageOffset_));
	}

	// U64 swappiness
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_swappinessOffset_", declaredType="U64")
	public UDATA swappiness() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMemoryInfo._swappinessOffset_));
	}

	// U64 swappiness
	public UDATAPointer swappinessEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupMemoryInfo._swappinessOffset_));
	}

}
