/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: JDK1_1InitArgs
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class JDK1_1InitArgs {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _abortOffset_;
	public static final int _checkSourceOffset_;
	public static final int _classpathOffset_;
	public static final int _debugAgentOffset_;
	public static final int _debugPortOffset_;
	public static final int _disableAsyncGCOffset_;
	public static final int _enableClassGCOffset_;
	public static final int _enableVerboseGCOffset_;
	public static final int _exitOffset_;
	public static final int _javaStackSizeOffset_;
	public static final int _maxHeapSizeOffset_;
	public static final int _minHeapSizeOffset_;
	public static final int _nativeStackSizeOffset_;
	public static final int _propertiesOffset_;
	public static final int _verboseOffset_;
	public static final int _verifyModeOffset_;
	public static final int _versionOffset_;
	public static final int _vfprintfOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_abortOffset_ = 0;
		_checkSourceOffset_ = 0;
		_classpathOffset_ = 0;
		_debugAgentOffset_ = 0;
		_debugPortOffset_ = 0;
		_disableAsyncGCOffset_ = 0;
		_enableClassGCOffset_ = 0;
		_enableVerboseGCOffset_ = 0;
		_exitOffset_ = 0;
		_javaStackSizeOffset_ = 0;
		_maxHeapSizeOffset_ = 0;
		_minHeapSizeOffset_ = 0;
		_nativeStackSizeOffset_ = 0;
		_propertiesOffset_ = 0;
		_verboseOffset_ = 0;
		_verifyModeOffset_ = 0;
		_versionOffset_ = 0;
		_vfprintfOffset_ = 0;
	}

}
