/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ParallelDispatcher
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ParallelDispatcher {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __activeThreadCountOffset_;
	public static final int __defaultOSStackSizeOffset_;
	public static final int __dispatcherMonitorOffset_;
	public static final int __extensionsOffset_;
	public static final int __handlerOffset_;
	public static final int __handler_argOffset_;
	public static final int __inShutdownOffset_;
	public static final int __poolMaxCapacityOffset_;
	public static final int __statusTableOffset_;
	public static final int __synchronizeMutexOffset_;
	public static final int __taskOffset_;
	public static final int __taskTableOffset_;
	public static final int __threadCountOffset_;
	public static final int __threadCountMaximumOffset_;
	public static final int __threadShutdownCountOffset_;
	public static final int __threadTableOffset_;
	public static final int __threadsToReserveOffset_;
	public static final int __workerThreadMutexOffset_;
	public static final int __workerThreadsReservedForGCOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__activeThreadCountOffset_ = 0;
		__defaultOSStackSizeOffset_ = 0;
		__dispatcherMonitorOffset_ = 0;
		__extensionsOffset_ = 0;
		__handlerOffset_ = 0;
		__handler_argOffset_ = 0;
		__inShutdownOffset_ = 0;
		__poolMaxCapacityOffset_ = 0;
		__statusTableOffset_ = 0;
		__synchronizeMutexOffset_ = 0;
		__taskOffset_ = 0;
		__taskTableOffset_ = 0;
		__threadCountOffset_ = 0;
		__threadCountMaximumOffset_ = 0;
		__threadShutdownCountOffset_ = 0;
		__threadTableOffset_ = 0;
		__threadsToReserveOffset_ = 0;
		__workerThreadMutexOffset_ = 0;
		__workerThreadsReservedForGCOffset_ = 0;
	}

}
