/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: CPUInformationEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the CPUInformationEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=CPUInformationEntry.class)
public class CPUInformationEntryPointer extends StructurePointer {

	// NULL
	public static final CPUInformationEntryPointer NULL = new CPUInformationEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected CPUInformationEntryPointer(long address) {
		super(address);
	}

	public static CPUInformationEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static CPUInformationEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static CPUInformationEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new CPUInformationEntryPointer(address);
	}

	public CPUInformationEntryPointer add(long count) {
		return CPUInformationEntryPointer.cast(address + (CPUInformationEntry.SIZEOF * count));
	}

	public CPUInformationEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public CPUInformationEntryPointer addOffset(long offset) {
		return CPUInformationEntryPointer.cast(address + offset);
	}

	public CPUInformationEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public CPUInformationEntryPointer sub(long count) {
		return CPUInformationEntryPointer.cast(address - (CPUInformationEntry.SIZEOF * count));
	}

	public CPUInformationEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public CPUInformationEntryPointer subOffset(long offset) {
		return CPUInformationEntryPointer.cast(address - offset);
	}

	public CPUInformationEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public CPUInformationEntryPointer untag(long mask) {
		return CPUInformationEntryPointer.cast(address & ~mask);
	}

	public CPUInformationEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return CPUInformationEntry.SIZEOF;
	}

	// Implementation methods

	// U32 cores
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_coresOffset_", declaredType="U32")
	public UDATA cores() throws CorruptDataException {
		return new U32(getIntAtOffset(CPUInformationEntry._coresOffset_));
	}

	// U32 cores
	public UDATAPointer coresEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(CPUInformationEntry._coresOffset_));
	}

	// const U8* cpu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpuOffset_", declaredType="const U8*")
	public U8Pointer cpu() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(CPUInformationEntry._cpuOffset_));
	}

	// const U8* cpu
	public PointerPointer cpuEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(CPUInformationEntry._cpuOffset_));
	}

	// U8* description
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_descriptionOffset_", declaredType="U8*")
	public U8Pointer description() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(CPUInformationEntry._descriptionOffset_));
	}

	// U8* description
	public PointerPointer descriptionEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(CPUInformationEntry._descriptionOffset_));
	}

	// U32 hwThreads
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hwThreadsOffset_", declaredType="U32")
	public UDATA hwThreads() throws CorruptDataException {
		return new U32(getIntAtOffset(CPUInformationEntry._hwThreadsOffset_));
	}

	// U32 hwThreads
	public UDATAPointer hwThreadsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(CPUInformationEntry._hwThreadsOffset_));
	}

	// U32 sockets
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_socketsOffset_", declaredType="U32")
	public UDATA sockets() throws CorruptDataException {
		return new U32(getIntAtOffset(CPUInformationEntry._socketsOffset_));
	}

	// U32 sockets
	public UDATAPointer socketsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(CPUInformationEntry._socketsOffset_));
	}

}
