/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: malloc_chunkPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the malloc_chunkPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=malloc_chunk.class)
public class malloc_chunkPointer extends StructurePointer {

	// NULL
	public static final malloc_chunkPointer NULL = new malloc_chunkPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected malloc_chunkPointer(long address) {
		super(address);
	}

	public static malloc_chunkPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static malloc_chunkPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static malloc_chunkPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new malloc_chunkPointer(address);
	}

	public malloc_chunkPointer add(long count) {
		return malloc_chunkPointer.cast(address + (malloc_chunk.SIZEOF * count));
	}

	public malloc_chunkPointer add(Scalar count) {
		return add(count.longValue());
	}

	public malloc_chunkPointer addOffset(long offset) {
		return malloc_chunkPointer.cast(address + offset);
	}

	public malloc_chunkPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public malloc_chunkPointer sub(long count) {
		return malloc_chunkPointer.cast(address - (malloc_chunk.SIZEOF * count));
	}

	public malloc_chunkPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public malloc_chunkPointer subOffset(long offset) {
		return malloc_chunkPointer.cast(address - offset);
	}

	public malloc_chunkPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public malloc_chunkPointer untag(long mask) {
		return malloc_chunkPointer.cast(address & ~mask);
	}

	public malloc_chunkPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return malloc_chunk.SIZEOF;
	}

	// Implementation methods

	// malloc_chunk* bk
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bkOffset_", declaredType="malloc_chunk*")
	public malloc_chunkPointer bk() throws CorruptDataException {
		return malloc_chunkPointer.cast(getPointerAtOffset(malloc_chunk._bkOffset_));
	}

	// malloc_chunk* bk
	public PointerPointer bkEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_chunk._bkOffset_));
	}

	// malloc_chunk* fd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fdOffset_", declaredType="malloc_chunk*")
	public malloc_chunkPointer fd() throws CorruptDataException {
		return malloc_chunkPointer.cast(getPointerAtOffset(malloc_chunk._fdOffset_));
	}

	// malloc_chunk* fd
	public PointerPointer fdEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(malloc_chunk._fdOffset_));
	}

	// size_t head
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_headOffset_", declaredType="size_t")
	public UDATA head() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_chunk._headOffset_));
	}

	// size_t head
	public UDATAPointer headEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_chunk._headOffset_));
	}

	// size_t prev_foot
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prev_footOffset_", declaredType="size_t")
	public UDATA prev_foot() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_chunk._prev_footOffset_));
	}

	// size_t prev_foot
	public UDATAPointer prev_footEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_chunk._prev_footOffset_));
	}

}
