/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cli.predicate;

import java.util.function.BooleanSupplier;
import jdk.test.lib.Platform;
import jdk.test.whitebox.cpuinfo.CPUInfo;

public class CPUSpecificPredicate
implements BooleanSupplier {
    private final String cpuArchPattern;
    private final String[] supportedCPUFeatures;
    private final String[] unsupportedCPUFeatures;

    public CPUSpecificPredicate(String cpuArchPattern, String[] supportedCPUFeatures, String[] unsupportedCPUFeatures) {
        this.cpuArchPattern = cpuArchPattern;
        this.supportedCPUFeatures = supportedCPUFeatures;
        this.unsupportedCPUFeatures = unsupportedCPUFeatures;
    }

    @Override
    public boolean getAsBoolean() {
        if (!Platform.getOsArch().matches(this.cpuArchPattern)) {
            System.out.println("CPU arch " + Platform.getOsArch() + " does not match " + this.cpuArchPattern);
            return false;
        }
        if (this.supportedCPUFeatures != null) {
            for (String feature : this.supportedCPUFeatures) {
                if (CPUInfo.hasFeature(feature)) continue;
                System.out.println("CPU does not support " + feature + " feature");
                return false;
            }
        }
        if (this.unsupportedCPUFeatures != null) {
            for (String feature : this.unsupportedCPUFeatures) {
                if (!CPUInfo.hasFeature(feature)) continue;
                System.out.println("CPU support " + feature + " feature");
                return false;
            }
        }
        return true;
    }
}

