/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9BCTranslationData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9BCTranslationData {

	// VM Constants

	public static final long SIZEOF;
	public static final long BCT_BigEndianOutput;
	public static final long BCT_DumpMaps;
	public static final long BCT_DumpPreverifyData;
	public static final long BCT_IntermediateDataIsClassfile;
	public static final long BCT_J9DescriptionCpTypeClass;
	public static final long BCT_J9DescriptionCpTypeMask;
	public static final long BCT_J9DescriptionCpTypeMethodHandle;
	public static final long BCT_J9DescriptionCpTypeMethodType;
	public static final long BCT_J9DescriptionCpTypeObject;
	public static final long BCT_J9DescriptionCpTypeScalar;
	public static final long BCT_J9DescriptionCpTypeShift;
	public static final long BCT_J9DescriptionImmediate;
	public static final long BCT_LittleEndianOutput;
	public static final long BCT_MajorClassFileVersionMask;
	public static final long BCT_MajorClassFileVersionMaskShift;
	public static final long BCT_RetainRuntimeInvisibleAttributes;
	public static final long BCT_StaticVerification;
	public static final long BCT_StripDebugAttributes;
	public static final long BCT_StripDebugLines;
	public static final long BCT_StripDebugSource;
	public static final long BCT_StripDebugVars;
	public static final long BCT_StripSourceDebugExtension;
	public static final long BCT_Xfuture;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		BCT_BigEndianOutput = 0;
		BCT_DumpMaps = 0;
		BCT_DumpPreverifyData = 0;
		BCT_IntermediateDataIsClassfile = 0;
		BCT_J9DescriptionCpTypeClass = 0;
		BCT_J9DescriptionCpTypeMask = 0;
		BCT_J9DescriptionCpTypeMethodHandle = 0;
		BCT_J9DescriptionCpTypeMethodType = 0;
		BCT_J9DescriptionCpTypeObject = 0;
		BCT_J9DescriptionCpTypeScalar = 0;
		BCT_J9DescriptionCpTypeShift = 0;
		BCT_J9DescriptionImmediate = 0;
		BCT_LittleEndianOutput = 0;
		BCT_MajorClassFileVersionMask = 0;
		BCT_MajorClassFileVersionMaskShift = 0;
		BCT_RetainRuntimeInvisibleAttributes = 0;
		BCT_StaticVerification = 0;
		BCT_StripDebugAttributes = 0;
		BCT_StripDebugLines = 0;
		BCT_StripDebugSource = 0;
		BCT_StripDebugVars = 0;
		BCT_StripSourceDebugExtension = 0;
		BCT_Xfuture = 0;
	}

}
