/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9VMContinuationPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9VMContinuationPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9VMContinuation.class)
public class J9VMContinuationPointer extends StructurePointer {

	// NULL
	public static final J9VMContinuationPointer NULL = new J9VMContinuationPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9VMContinuationPointer(long address) {
		super(address);
	}

	public static J9VMContinuationPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9VMContinuationPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9VMContinuationPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9VMContinuationPointer(address);
	}

	public J9VMContinuationPointer add(long count) {
		return J9VMContinuationPointer.cast(address + (J9VMContinuation.SIZEOF * count));
	}

	public J9VMContinuationPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9VMContinuationPointer addOffset(long offset) {
		return J9VMContinuationPointer.cast(address + offset);
	}

	public J9VMContinuationPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9VMContinuationPointer sub(long count) {
		return J9VMContinuationPointer.cast(address - (J9VMContinuation.SIZEOF * count));
	}

	public J9VMContinuationPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9VMContinuationPointer subOffset(long offset) {
		return J9VMContinuationPointer.cast(address - offset);
	}

	public J9VMContinuationPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9VMContinuationPointer untag(long mask) {
		return J9VMContinuationPointer.cast(address & ~mask);
	}

	public J9VMContinuationPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9VMContinuation.SIZEOF;
	}

	// Implementation methods

	// UDATA* arg0EA
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_arg0EAOffset_", declaredType="UDATA*")
	public UDATAPointer arg0EA() throws CorruptDataException, NoSuchFieldException {
	try {
		return UDATAPointer.cast(getPointerAtOffset(J9VMContinuation._arg0EAOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA* arg0EA
	public PointerPointer arg0EAEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._arg0EAOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA* bytecodes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bytecodesOffset_", declaredType="UDATA*")
	public UDATAPointer bytecodes() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMContinuation._bytecodesOffset_));
	}

	// UDATA* bytecodes
	public PointerPointer bytecodesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._bytecodesOffset_));
	}

	// J9JITDecompilationInfo* decompilationStack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decompilationStackOffset_", declaredType="J9JITDecompilationInfo*")
	public J9JITDecompilationInfoPointer decompilationStack() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9JITDecompilationInfoPointer.cast(getPointerAtOffset(J9VMContinuation._decompilationStackOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9JITDecompilationInfo* decompilationStack
	public PointerPointer decompilationStackEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._decompilationStackOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA dropFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dropFlagsOffset_", declaredType="UDATA")
	public UDATA dropFlags() throws CorruptDataException {
		return getUDATAAtOffset(J9VMContinuation._dropFlagsOffset_);
	}

	// UDATA dropFlags
	public UDATAPointer dropFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMContinuation._dropFlagsOffset_));
	}

	// J9ObjectMonitor* enteredMonitors
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_enteredMonitorsOffset_", declaredType="J9ObjectMonitor*")
	public J9ObjectMonitorPointer enteredMonitors() throws CorruptDataException {
		return J9ObjectMonitorPointer.cast(getPointerAtOffset(J9VMContinuation._enteredMonitorsOffset_));
	}

	// J9ObjectMonitor* enteredMonitors
	public PointerPointer enteredMonitorsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._enteredMonitorsOffset_));
	}

	// J9I2JState i2jState
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_i2jStateOffset_", declaredType="J9I2JState")
	public J9I2JStatePointer i2jState() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9I2JStatePointer.cast(nonNullFieldEA(J9VMContinuation._i2jStateOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9I2JState i2jState
	public PointerPointer i2jStateEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._i2jStateOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA* j2iFrame
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_j2iFrameOffset_", declaredType="UDATA*")
	public UDATAPointer j2iFrame() throws CorruptDataException, NoSuchFieldException {
	try {
		return UDATAPointer.cast(getPointerAtOffset(J9VMContinuation._j2iFrameOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA* j2iFrame
	public PointerPointer j2iFrameEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._j2iFrameOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9JITGPRSpillArea jitGPRs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jitGPRsOffset_", declaredType="J9JITGPRSpillArea")
	public J9JITGPRSpillAreaPointer jitGPRs() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9JITGPRSpillAreaPointer.cast(nonNullFieldEA(J9VMContinuation._jitGPRsOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9JITGPRSpillArea jitGPRs
	public PointerPointer jitGPRsEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._jitGPRsOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9MonitorEnterRecord* jniMonitorEnterRecords
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jniMonitorEnterRecordsOffset_", declaredType="J9MonitorEnterRecord*")
	public J9MonitorEnterRecordPointer jniMonitorEnterRecords() throws CorruptDataException {
		return J9MonitorEnterRecordPointer.cast(getPointerAtOffset(J9VMContinuation._jniMonitorEnterRecordsOffset_));
	}

	// J9MonitorEnterRecord* jniMonitorEnterRecords
	public PointerPointer jniMonitorEnterRecordsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._jniMonitorEnterRecordsOffset_));
	}

	// J9Method* literals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_literalsOffset_", declaredType="J9Method*")
	public J9MethodPointer literals() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9MethodPointer.cast(getPointerAtOffset(J9VMContinuation._literalsOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9Method* literals
	public PointerPointer literalsEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._literalsOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9Pool* monitorEnterRecordPool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_monitorEnterRecordPoolOffset_", declaredType="J9Pool*")
	public J9PoolPointer monitorEnterRecordPool() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(J9VMContinuation._monitorEnterRecordPoolOffset_));
	}

	// J9Pool* monitorEnterRecordPool
	public PointerPointer monitorEnterRecordPoolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._monitorEnterRecordPoolOffset_));
	}

	// J9MonitorEnterRecord* monitorEnterRecords
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_monitorEnterRecordsOffset_", declaredType="J9MonitorEnterRecord*")
	public J9MonitorEnterRecordPointer monitorEnterRecords() throws CorruptDataException {
		return J9MonitorEnterRecordPointer.cast(getPointerAtOffset(J9VMContinuation._monitorEnterRecordsOffset_));
	}

	// J9MonitorEnterRecord* monitorEnterRecords
	public PointerPointer monitorEnterRecordsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._monitorEnterRecordsOffset_));
	}

	// J9VMContinuation* nextWaitingContinuation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextWaitingContinuationOffset_", declaredType="J9VMContinuation*")
	public J9VMContinuationPointer nextWaitingContinuation() throws CorruptDataException {
		return J9VMContinuationPointer.cast(getPointerAtOffset(J9VMContinuation._nextWaitingContinuationOffset_));
	}

	// J9VMContinuation* nextWaitingContinuation
	public PointerPointer nextWaitingContinuationEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._nextWaitingContinuationOffset_));
	}

	// J9ObjectMonitor* objectWaitMonitor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objectWaitMonitorOffset_", declaredType="J9ObjectMonitor*")
	public J9ObjectMonitorPointer objectWaitMonitor() throws CorruptDataException {
		return J9ObjectMonitorPointer.cast(getPointerAtOffset(J9VMContinuation._objectWaitMonitorOffset_));
	}

	// J9ObjectMonitor* objectWaitMonitor
	public PointerPointer objectWaitMonitorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._objectWaitMonitorOffset_));
	}

	// J9VMEntryLocalStorage* oldEntryLocalStorage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_oldEntryLocalStorageOffset_", declaredType="J9VMEntryLocalStorage*")
	public J9VMEntryLocalStoragePointer oldEntryLocalStorage() throws CorruptDataException, NoSuchFieldException {
	try {
		return J9VMEntryLocalStoragePointer.cast(getPointerAtOffset(J9VMContinuation._oldEntryLocalStorageOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9VMEntryLocalStorage* oldEntryLocalStorage
	public PointerPointer oldEntryLocalStorageEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._oldEntryLocalStorageOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA ownedMonitorCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ownedMonitorCountOffset_", declaredType="UDATA")
	public UDATA ownedMonitorCount() throws CorruptDataException {
		return getUDATAAtOffset(J9VMContinuation._ownedMonitorCountOffset_);
	}

	// UDATA ownedMonitorCount
	public UDATAPointer ownedMonitorCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMContinuation._ownedMonitorCountOffset_));
	}

	// U8* pc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcOffset_", declaredType="U8*")
	public U8Pointer pc() throws CorruptDataException, NoSuchFieldException {
	try {
		return U8Pointer.cast(getPointerAtOffset(J9VMContinuation._pcOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// U8* pc
	public PointerPointer pcEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._pcOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9VMThread* previousOwner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_previousOwnerOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer previousOwner() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(J9VMContinuation._previousOwnerOffset_));
	}

	// J9VMThread* previousOwner
	public PointerPointer previousOwnerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._previousOwnerOffset_));
	}

	// UDATA returnState
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_returnStateOffset_", declaredType="UDATA")
	public UDATA returnState() throws CorruptDataException {
		return getUDATAAtOffset(J9VMContinuation._returnStateOffset_);
	}

	// UDATA returnState
	public UDATAPointer returnStateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMContinuation._returnStateOffset_));
	}

	// UDATA runtimeFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runtimeFlagsOffset_", declaredType="UDATA")
	public UDATA runtimeFlags() throws CorruptDataException {
		return getUDATAAtOffset(J9VMContinuation._runtimeFlagsOffset_);
	}

	// UDATA runtimeFlags
	public UDATAPointer runtimeFlagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9VMContinuation._runtimeFlagsOffset_));
	}

	// UDATA* sp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spOffset_", declaredType="UDATA*")
	public UDATAPointer sp() throws CorruptDataException, NoSuchFieldException {
	try {
		return UDATAPointer.cast(getPointerAtOffset(J9VMContinuation._spOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// UDATA* sp
	public PointerPointer spEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._spOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// J9JavaStack* stackObject
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackObjectOffset_", declaredType="J9JavaStack*")
	public J9JavaStackPointer stackObject() throws CorruptDataException {
		return J9JavaStackPointer.cast(getPointerAtOffset(J9VMContinuation._stackObjectOffset_));
	}

	// J9JavaStack* stackObject
	public PointerPointer stackObjectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._stackObjectOffset_));
	}

	// UDATA* stackOverflowMark
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackOverflowMarkOffset_", declaredType="UDATA*")
	public UDATAPointer stackOverflowMark() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMContinuation._stackOverflowMarkOffset_));
	}

	// UDATA* stackOverflowMark
	public PointerPointer stackOverflowMarkEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._stackOverflowMarkOffset_));
	}

	// UDATA* stackOverflowMark2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stackOverflowMark2Offset_", declaredType="UDATA*")
	public UDATAPointer stackOverflowMark2() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9VMContinuation._stackOverflowMark2Offset_));
	}

	// UDATA* stackOverflowMark2
	public PointerPointer stackOverflowMark2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._stackOverflowMark2Offset_));
	}

	// I64 startTicks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_startTicksOffset_", declaredType="I64")
	public IDATA startTicks() throws CorruptDataException {
		return new I64(getLongAtOffset(J9VMContinuation._startTicksOffset_));
	}

	// I64 startTicks
	public IDATAPointer startTicksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9VMContinuation._startTicksOffset_));
	}

	// j9object_t vthread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vthreadOffset_", declaredType="j9object_t")
	public J9ObjectPointer vthread() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(J9VMContinuation._vthreadOffset_));
	}

	// j9object_t vthread
	public PointerPointer vthreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9VMContinuation._vthreadOffset_));
	}

	// IDATA waitingMonitorEnterCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_waitingMonitorEnterCountOffset_", declaredType="IDATA")
	public IDATA waitingMonitorEnterCount() throws CorruptDataException {
		return getIDATAAtOffset(J9VMContinuation._waitingMonitorEnterCountOffset_);
	}

	// IDATA waitingMonitorEnterCount
	public IDATAPointer waitingMonitorEnterCountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9VMContinuation._waitingMonitorEnterCountOffset_));
	}

}
