/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: JFRStatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the JFRStatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=JFRState.class)
public class JFRStatePointer extends StructurePointer {

	// NULL
	public static final JFRStatePointer NULL = new JFRStatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected JFRStatePointer(long address) {
		super(address);
	}

	public static JFRStatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static JFRStatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static JFRStatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new JFRStatePointer(address);
	}

	public JFRStatePointer add(long count) {
		return JFRStatePointer.cast(address + (JFRState.SIZEOF * count));
	}

	public JFRStatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public JFRStatePointer addOffset(long offset) {
		return JFRStatePointer.cast(address + offset);
	}

	public JFRStatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public JFRStatePointer sub(long count) {
		return JFRStatePointer.cast(address - (JFRState.SIZEOF * count));
	}

	public JFRStatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public JFRStatePointer subOffset(long offset) {
		return JFRStatePointer.cast(address - offset);
	}

	public JFRStatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public JFRStatePointer untag(long mask) {
		return JFRStatePointer.cast(address & ~mask);
	}

	public JFRStatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return JFRState.SIZEOF;
	}

	// Implementation methods

	// IDATA blobFileDescriptor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_blobFileDescriptorOffset_", declaredType="IDATA")
	public IDATA blobFileDescriptor() throws CorruptDataException {
		return getIDATAAtOffset(JFRState._blobFileDescriptorOffset_);
	}

	// IDATA blobFileDescriptor
	public IDATAPointer blobFileDescriptorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JFRState._blobFileDescriptorOffset_));
	}

	// I64 chunkStartTicks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_chunkStartTicksOffset_", declaredType="I64")
	public IDATA chunkStartTicks() throws CorruptDataException {
		return new I64(getLongAtOffset(JFRState._chunkStartTicksOffset_));
	}

	// I64 chunkStartTicks
	public IDATAPointer chunkStartTicksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JFRState._chunkStartTicksOffset_));
	}

	// I64 chunkStartTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_chunkStartTimeOffset_", declaredType="I64")
	public IDATA chunkStartTime() throws CorruptDataException {
		return new I64(getLongAtOffset(JFRState._chunkStartTimeOffset_));
	}

	// I64 chunkStartTime
	public IDATAPointer chunkStartTimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JFRState._chunkStartTimeOffset_));
	}

	// void* constantEvents
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_constantEventsOffset_", declaredType="void*")
	public VoidPointer constantEvents() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(JFRState._constantEventsOffset_));
	}

	// void* constantEvents
	public PointerPointer constantEventsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._constantEventsOffset_));
	}

	// BOOLEAN isConstantEventsInitialized
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_isConstantEventsInitializedOffset_", declaredType="BOOLEAN")
	public UDATA isConstantEventsInitialized() throws CorruptDataException {
		return new U32(getIntAtOffset(JFRState._isConstantEventsInitializedOffset_));
	}

	// BOOLEAN isConstantEventsInitialized
	public UDATAPointer isConstantEventsInitializedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(JFRState._isConstantEventsInitializedOffset_));
	}

	// omrthread_monitor_t isConstantEventsInitializedMutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_isConstantEventsInitializedMutexOffset_", declaredType="omrthread_monitor_t")
	public J9ThreadMonitorPointer isConstantEventsInitializedMutex() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(JFRState._isConstantEventsInitializedMutexOffset_));
	}

	// omrthread_monitor_t isConstantEventsInitializedMutex
	public PointerPointer isConstantEventsInitializedMutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._isConstantEventsInitializedMutexOffset_));
	}

	// BOOLEAN isStarted
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_isStartedOffset_", declaredType="BOOLEAN")
	public UDATA isStarted() throws CorruptDataException {
		return new U32(getIntAtOffset(JFRState._isStartedOffset_));
	}

	// BOOLEAN isStarted
	public UDATAPointer isStartedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(JFRState._isStartedOffset_));
	}

	// UDATA jfrChunkCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jfrChunkCountOffset_", declaredType="UDATA")
	public UDATA jfrChunkCount() throws CorruptDataException {
		return getUDATAAtOffset(JFRState._jfrChunkCountOffset_);
	}

	// UDATA jfrChunkCount
	public UDATAPointer jfrChunkCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(JFRState._jfrChunkCountOffset_));
	}

	// U8* jfrFileName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jfrFileNameOffset_", declaredType="U8*")
	public U8Pointer jfrFileName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JFRState._jfrFileNameOffset_));
	}

	// U8* jfrFileName
	public PointerPointer jfrFileNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._jfrFileNameOffset_));
	}

	// void* jfrWriter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jfrWriterOffset_", declaredType="void*")
	public VoidPointer jfrWriter() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(JFRState._jfrWriterOffset_));
	}

	// void* jfrWriter
	public PointerPointer jfrWriterEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._jfrWriterOffset_));
	}

	// U8* metaDataBlobFile
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_metaDataBlobFileOffset_", declaredType="U8*")
	public U8Pointer metaDataBlobFile() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(JFRState._metaDataBlobFileOffset_));
	}

	// U8* metaDataBlobFile
	public PointerPointer metaDataBlobFileEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._metaDataBlobFileOffset_));
	}

	// UDATA metaDataBlobFileSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_metaDataBlobFileSizeOffset_", declaredType="UDATA")
	public UDATA metaDataBlobFileSize() throws CorruptDataException {
		return getUDATAAtOffset(JFRState._metaDataBlobFileSizeOffset_);
	}

	// UDATA metaDataBlobFileSize
	public UDATAPointer metaDataBlobFileSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(JFRState._metaDataBlobFileSizeOffset_));
	}

	// I64 prevContextSwitchTimestamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevContextSwitchTimestampOffset_", declaredType="I64")
	public IDATA prevContextSwitchTimestamp() throws CorruptDataException {
		return new I64(getLongAtOffset(JFRState._prevContextSwitchTimestampOffset_));
	}

	// I64 prevContextSwitchTimestamp
	public IDATAPointer prevContextSwitchTimestampEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JFRState._prevContextSwitchTimestampOffset_));
	}

	// U64 prevContextSwitches
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevContextSwitchesOffset_", declaredType="U64")
	public UDATA prevContextSwitches() throws CorruptDataException {
		return new U64(getLongAtOffset(JFRState._prevContextSwitchesOffset_));
	}

	// U64 prevContextSwitches
	public UDATAPointer prevContextSwitchesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(JFRState._prevContextSwitchesOffset_));
	}

	// omrthread_process_time_t prevProcCPUTimes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevProcCPUTimesOffset_", declaredType="omrthread_process_time_t")
	public omrthread_process_time_tPointer prevProcCPUTimes() throws CorruptDataException {
		return omrthread_process_time_tPointer.cast(nonNullFieldEA(JFRState._prevProcCPUTimesOffset_));
	}

	// omrthread_process_time_t prevProcCPUTimes
	public PointerPointer prevProcCPUTimesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._prevProcCPUTimesOffset_));
	}

	// I64 prevProcTimestamp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevProcTimestampOffset_", declaredType="I64")
	public IDATA prevProcTimestamp() throws CorruptDataException {
		return new I64(getLongAtOffset(JFRState._prevProcTimestampOffset_));
	}

	// I64 prevProcTimestamp
	public IDATAPointer prevProcTimestampEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JFRState._prevProcTimestampOffset_));
	}

	// J9SysinfoCPUTime prevSysCPUTime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevSysCPUTimeOffset_", declaredType="J9SysinfoCPUTime")
	public J9SysinfoCPUTimePointer prevSysCPUTime() throws CorruptDataException {
		return J9SysinfoCPUTimePointer.cast(nonNullFieldEA(JFRState._prevSysCPUTimeOffset_));
	}

	// J9SysinfoCPUTime prevSysCPUTime
	public PointerPointer prevSysCPUTimeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._prevSysCPUTimeOffset_));
	}

	// omrthread_monitor_t typeIDMonitor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeIDMonitorOffset_", declaredType="omrthread_monitor_t")
	public J9ThreadMonitorPointer typeIDMonitor() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(JFRState._typeIDMonitorOffset_));
	}

	// omrthread_monitor_t typeIDMonitor
	public PointerPointer typeIDMonitorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRState._typeIDMonitorOffset_));
	}

	// jlong typeIDcount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeIDcountOffset_", declaredType="jlong")
	public IDATA typeIDcount() throws CorruptDataException {
		return new I64(getLongAtOffset(JFRState._typeIDcountOffset_));
	}

	// jlong typeIDcount
	public IDATAPointer typeIDcountEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(JFRState._typeIDcountOffset_));
	}

}
