/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: JFRState
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class JFRState {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _blobFileDescriptorOffset_;
	public static final int _chunkStartTicksOffset_;
	public static final int _chunkStartTimeOffset_;
	public static final int _constantEventsOffset_;
	public static final int _isConstantEventsInitializedOffset_;
	public static final int _isConstantEventsInitializedMutexOffset_;
	public static final int _isStartedOffset_;
	public static final int _jfrChunkCountOffset_;
	public static final int _jfrFileNameOffset_;
	public static final int _jfrWriterOffset_;
	public static final int _metaDataBlobFileOffset_;
	public static final int _metaDataBlobFileSizeOffset_;
	public static final int _prevContextSwitchTimestampOffset_;
	public static final int _prevContextSwitchesOffset_;
	public static final int _prevProcCPUTimesOffset_;
	public static final int _prevProcTimestampOffset_;
	public static final int _prevSysCPUTimeOffset_;
	public static final int _typeIDMonitorOffset_;
	public static final int _typeIDcountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_blobFileDescriptorOffset_ = 0;
		_chunkStartTicksOffset_ = 0;
		_chunkStartTimeOffset_ = 0;
		_constantEventsOffset_ = 0;
		_isConstantEventsInitializedOffset_ = 0;
		_isConstantEventsInitializedMutexOffset_ = 0;
		_isStartedOffset_ = 0;
		_jfrChunkCountOffset_ = 0;
		_jfrFileNameOffset_ = 0;
		_jfrWriterOffset_ = 0;
		_metaDataBlobFileOffset_ = 0;
		_metaDataBlobFileSizeOffset_ = 0;
		_prevContextSwitchTimestampOffset_ = 0;
		_prevContextSwitchesOffset_ = 0;
		_prevProcCPUTimesOffset_ = 0;
		_prevProcTimestampOffset_ = 0;
		_prevSysCPUTimeOffset_ = 0;
		_typeIDMonitorOffset_ = 0;
		_typeIDcountOffset_ = 0;
	}

}
