/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_LargeObjectAllocateStats
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_LargeObjectAllocateStats {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __TLHFrequentAllocationSizeOffset_;
	public static final int __TLHSizeClassIndexOffset_;
	public static final int __averageBytesAllocatedOffset_;
	public static final int __cpuTimeEstimateFragmentationOffset_;
	public static final int __envOffset_;
	public static final int __freeEntrySizeClassStatsOffset_;
	public static final int __freeMemoryBeforeEstimateOffset_;
	public static final int __largeObjectThresholdOffset_;
	public static final int __maxAllocateSizesOffset_;
	public static final int __maxHeapSizeOffset_;
	public static final int __remainingFreeMemoryAfterEstimateOffset_;
	public static final int __sizeClassRatioOffset_;
	public static final int __sizeClassRatioLogOffset_;
	public static final int __sizeClassSizesOffset_;
	public static final int __spaceSavingSizeClassesOffset_;
	public static final int __spaceSavingSizeClassesAveragePercentOffset_;
	public static final int __spaceSavingSizesOffset_;
	public static final int __spaceSavingSizesAveragePercentOffset_;
	public static final int __spaceSavingTempOffset_;
	public static final int __timeEstimateFragmentationOffset_;
	public static final int __timeMergeAverageOffset_;
	public static final int __tlhAllocSizeClassStatsOffset_;
	public static final int __tlhMaximumSizeOffset_;
	public static final int __tlhMinimumSizeOffset_;
	public static final int __veryLargeEntrySizeClassOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__TLHFrequentAllocationSizeOffset_ = 0;
		__TLHSizeClassIndexOffset_ = 0;
		__averageBytesAllocatedOffset_ = 0;
		__cpuTimeEstimateFragmentationOffset_ = 0;
		__envOffset_ = 0;
		__freeEntrySizeClassStatsOffset_ = 0;
		__freeMemoryBeforeEstimateOffset_ = 0;
		__largeObjectThresholdOffset_ = 0;
		__maxAllocateSizesOffset_ = 0;
		__maxHeapSizeOffset_ = 0;
		__remainingFreeMemoryAfterEstimateOffset_ = 0;
		__sizeClassRatioOffset_ = 0;
		__sizeClassRatioLogOffset_ = 0;
		__sizeClassSizesOffset_ = 0;
		__spaceSavingSizeClassesOffset_ = 0;
		__spaceSavingSizeClassesAveragePercentOffset_ = 0;
		__spaceSavingSizesOffset_ = 0;
		__spaceSavingSizesAveragePercentOffset_ = 0;
		__spaceSavingTempOffset_ = 0;
		__timeEstimateFragmentationOffset_ = 0;
		__timeMergeAverageOffset_ = 0;
		__tlhAllocSizeClassStatsOffset_ = 0;
		__tlhMaximumSizeOffset_ = 0;
		__tlhMinimumSizeOffset_ = 0;
		__veryLargeEntrySizeClassOffset_ = 0;
	}

}
