/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_VerboseManagerBase
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_VerboseManagerBase {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __countOfOffset_;
	public static final int __curIdOffset_;
	public static final int __hooksAttachedOffset_;
	public static final int __indentationLevelOffset_;
	public static final int __lastOutputTimeOffset_;
	public static final int __mmPrivateHooksOffset_;
	public static final int __omrHooksOffset_;
	public static final int __omrVMOffset_;
	public static final int __outputCountOffset_;
	public static final int __startTimeOffset_;
	public static final int __timeOfLastOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__countOfOffset_ = 0;
		__curIdOffset_ = 0;
		__hooksAttachedOffset_ = 0;
		__indentationLevelOffset_ = 0;
		__lastOutputTimeOffset_ = 0;
		__mmPrivateHooksOffset_ = 0;
		__omrHooksOffset_ = 0;
		__omrVMOffset_ = 0;
		__outputCountOffset_ = 0;
		__startTimeOffset_ = 0;
		__timeOfLastOffset_ = 0;
	}

}
