/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9VmconstantpoolConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9VmconstantpoolConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9VMCONSTANTPOOL_COMIBMOTILANGTHREADDEATH;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIUTILWEAKREFERENCENODE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMREFLECTOBJECTINVALIDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_ADDRESS_SIZE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_FJ9OBJECT_SIZE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INITIALIZE_STATUS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCESIZE_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCE_DESCRIPTION_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_OFFSET_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_ROMCLASS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SIZE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SUPERCLASSES_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9ROMCLASS_MODIFIERS_OFFSET;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_SEGREGATED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_TLH;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_BALANCED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_GENCON;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_METRONOME;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTAVGPAUSE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTTHRUPUT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_ALWAYS;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_AND_OLDCHECK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_INCREMENTAL;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_NONE;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_OLDCHECK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_DEPTH_MASK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_RAM_SHAPE_SHIFT;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JIT_STRING_DEDUP_POLICY;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_STRING_COMPRESSION_ENABLED;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SHAPE_MASK;
	public static final long J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SIZE;
	public static final long J9VMCONSTANTPOOL_JAVAIOUTFDATAFORMATEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGABSTRACTMETHODERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGARITHMETICEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGARRAYINDEXOUTOFBOUNDSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGARRAYSTOREEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGBOOLEAN;
	public static final long J9VMCONSTANTPOOL_JAVALANGBOOLEAN_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGBYTE;
	public static final long J9VMCONSTANTPOOL_JAVALANGBYTE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCHARACTER;
	public static final long J9VMCONSTANTPOOL_JAVALANGCHARACTER_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSCASTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSCIRCULARITYERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSFORMATERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_CLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_ISPARALLELCAPABLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_LOADCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_PARENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_UNNAMEDMODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_VMREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASSNOTFOUNDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_ANNOTATIONCACHE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSLOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSNAMESTRING;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_INITIALIZATIONLOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_MODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_PROTECTIONDOMAIN;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_REFLECTCACHE;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLASS_VMREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGCLONENOTSUPPORTEDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGDOUBLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGDOUBLE_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGEXCEPTIONININITIALIZERERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGFLOAT;
	public static final long J9VMCONSTANTPOOL_JAVALANGFLOAT_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALARGUMENTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALMONITORSTATEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGILLEGALTHREADSTATEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINCOMPATIBLECLASSCHANGEERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINDEXOUTOFBOUNDSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTEGER;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTEGER_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTERNALERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINTERRUPTEDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_TYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_METHODDESCRIPTOR;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKENATIVEMETHODHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGINVOKEWRONGMETHODTYPEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK_THECLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_COMPLETEINITIALIZATION;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_FORMATNOSUCHMETHOD;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_INITIALIZATIONALREADYFAILED;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_NEWINSTANCEIMPL;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_RECORDINITIALIZATIONFAILURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_THREADCLEANUP;
	public static final long J9VMCONSTANTPOOL_JAVALANGLINKAGEERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGLONG;
	public static final long J9VMCONSTANTPOOL_JAVALANGLONG_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGMODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGMODULE_LOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGMODULE_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGNEGATIVEARRAYSIZEEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOCLASSDEFFOUNDERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGNULLPOINTEREXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGOBJECT;
	public static final long J9VMCONSTANTPOOL_JAVALANGOUTOFMEMORYERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_EXCEPTIONTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_TYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTINVOCATIONTARGETEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONDEFAULT;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_EXCEPTIONTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_MODIFIERS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERANNOTATIONS;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERTYPES;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_RETURNTYPE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_SIGNATURE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_QUEUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_REFERENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_STATE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE;
	public static final long J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE_AGE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSECURITYEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSHORT;
	public static final long J9VMCONSTANTPOOL_JAVALANGSHORT_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKOVERFLOWERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_CLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_FILENAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_LINENUMBER;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_METHODNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULENAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULEVERSION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_SOURCE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_BYTECODEINDEX;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CALLERSENSITIVE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSLOADERNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_DECLARINGCLASS;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FILENAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FRAMEMODULE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_LINENUMBER;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_METHODNAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRINGINDEXOUTOFBOUNDSEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRINGSTRINGCOMPRESSIONFLAG;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_COMPRESSIONFLAG;
	public static final long J9VMCONSTANTPOOL_JAVALANGSTRING_VALUE;
	public static final long J9VMCONSTANTPOOL_JAVALANGSYSTEM;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADDEATH;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_ISDAEMON;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_MAXPRIORITY;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_PARENT;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_CONTEXTCLASSLOADER;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_INIT;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_LOCK;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_NAME;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_PARKBLOCKER;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_STARTED;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_THREADREF;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_TID;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHREAD_UNCAUGHTEXCEPTION;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_DETAILMESSAGE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_STACKTRACE;
	public static final long J9VMCONSTANTPOOL_JAVALANGTHROWABLE_WALKBACK;
	public static final long J9VMCONSTANTPOOL_JAVALANGUNSATISFIEDLINKERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGUNSUPPORTEDCLASSVERSIONERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGVERIFYERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGVIRTUALMACHINEERROR;
	public static final long J9VMCONSTANTPOOL_JAVALANGVOID;
	public static final long J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER;
	public static final long J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER_EXCLUSIVEOWNERTHREAD;
	public static final long J9VM_VMCONSTANTPOOL_SIZE;
	public static final long JCL_RTFLAG_DEFAULT;
	public static final long JCL_RTFLAG_INTERP_HOT_CODE_REPLACEMENT;
	public static final long JCL_RTFLAG_JIT_NEW_INSTANCE_PROTOTYPE;
	public static final long JCL_RTFLAG_OPT_METHOD_HANDLE;
	public static final long JCL_RTFLAG_OPT_REFLECT;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9VMCONSTANTPOOL_COMIBMOTILANGTHREADDEATH = 0;
		J9VMCONSTANTPOOL_COMIBMOTIUTILWEAKREFERENCENODE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMREFLECTOBJECTINVALIDEXCEPTION = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_ADDRESS_SIZE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_FJ9OBJECT_SIZE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INITIALIZE_STATUS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCESIZE_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_INSTANCE_DESCRIPTION_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_LOCK_OFFSET_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_ROMCLASS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SIZE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9CLASS_SUPERCLASSES_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9ROMCLASS_MODIFIERS_OFFSET = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_SEGREGATED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_ALLOCATION_TYPE_TLH = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_BALANCED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_GENCON = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_METRONOME = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTAVGPAUSE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_POLICY_OPTTHRUPUT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_ALWAYS = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_AND_OLDCHECK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_CARDMARK_INCREMENTAL = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_NONE = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_GC_WRITE_BARRIER_TYPE_OLDCHECK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_DEPTH_MASK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JAVA_CLASS_RAM_SHAPE_SHIFT = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_JIT_STRING_DEDUP_POLICY = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_J9_STRING_COMPRESSION_ENABLED = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SHAPE_MASK = 0;
		J9VMCONSTANTPOOL_COMIBMOTIVMVM_OBJECT_HEADER_SIZE = 0;
		J9VMCONSTANTPOOL_JAVAIOUTFDATAFORMATEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGABSTRACTMETHODERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGARITHMETICEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGARRAYINDEXOUTOFBOUNDSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGARRAYSTOREEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGBOOLEAN = 0;
		J9VMCONSTANTPOOL_JAVALANGBOOLEAN_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGBYTE = 0;
		J9VMCONSTANTPOOL_JAVALANGBYTE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGCHARACTER = 0;
		J9VMCONSTANTPOOL_JAVALANGCHARACTER_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSCASTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSCIRCULARITYERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSFORMATERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_CLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_ISPARALLELCAPABLE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_LOADCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_PARENT = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_UNNAMEDMODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSLOADER_VMREF = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASSNOTFOUNDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_ANNOTATIONCACHE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSLOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_CLASSNAMESTRING = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_INITIALIZATIONLOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_MODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_PROTECTIONDOMAIN = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_REFLECTCACHE = 0;
		J9VMCONSTANTPOOL_JAVALANGCLASS_VMREF = 0;
		J9VMCONSTANTPOOL_JAVALANGCLONENOTSUPPORTEDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGDOUBLE = 0;
		J9VMCONSTANTPOOL_JAVALANGDOUBLE_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGEXCEPTIONININITIALIZERERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGFLOAT = 0;
		J9VMCONSTANTPOOL_JAVALANGFLOAT_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALACCESSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALARGUMENTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALMONITORSTATEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGILLEGALTHREADSTATEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINCOMPATIBLECLASSCHANGEERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGINDEXOUTOFBOUNDSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGINSTANTIATIONEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINTEGER = 0;
		J9VMCONSTANTPOOL_JAVALANGINTEGER_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGINTERNALERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGINTERRUPTEDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODHANDLE_TYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEMETHODTYPE_METHODDESCRIPTOR = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKENATIVEMETHODHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEVARHANDLE = 0;
		J9VMCONSTANTPOOL_JAVALANGINVOKEWRONGMETHODTYPEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALSCLASSINITIALIZATIONLOCK_THECLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_COMPLETEINITIALIZATION = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_FORMATNOSUCHMETHOD = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_INITIALIZATIONALREADYFAILED = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_NEWINSTANCEIMPL = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_RECORDINITIALIZATIONFAILURE = 0;
		J9VMCONSTANTPOOL_JAVALANGJ9VMINTERNALS_THREADCLEANUP = 0;
		J9VMCONSTANTPOOL_JAVALANGLINKAGEERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGLONG = 0;
		J9VMCONSTANTPOOL_JAVALANGLONG_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGMODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGMODULE_LOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGMODULE_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGNEGATIVEARRAYSIZEEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGNOCLASSDEFFOUNDERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHFIELDEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGNOSUCHMETHODEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGNULLPOINTEREXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGOBJECT = 0;
		J9VMCONSTANTPOOL_JAVALANGOUTOFMEMORYERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_EXCEPTIONTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_PARAMETERTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTCONSTRUCTOR_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTFIELD_TYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTINVOCATIONTARGETEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONDEFAULT = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_ANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_EXCEPTIONTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_MODIFIERS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERANNOTATIONS = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_PARAMETERTYPES = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_RETURNTYPE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFLECTMETHOD_SIGNATURE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_QUEUE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_REFERENT = 0;
		J9VMCONSTANTPOOL_JAVALANGREFREFERENCE_STATE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE = 0;
		J9VMCONSTANTPOOL_JAVALANGREFSOFTREFERENCE_AGE = 0;
		J9VMCONSTANTPOOL_JAVALANGSECURITYEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGSHORT = 0;
		J9VMCONSTANTPOOL_JAVALANGSHORT_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKOVERFLOWERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_CLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_FILENAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_LINENUMBER = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_METHODNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULENAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_MODULEVERSION = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKTRACEELEMENT_SOURCE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_BYTECODEINDEX = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CALLERSENSITIVE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSLOADERNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_CLASSNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_DECLARINGCLASS = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FILENAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_FRAMEMODULE = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_LINENUMBER = 0;
		J9VMCONSTANTPOOL_JAVALANGSTACKWALKERSTACKFRAMEIMPL_METHODNAME = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRINGINDEXOUTOFBOUNDSEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRINGSTRINGCOMPRESSIONFLAG = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_COMPRESSIONFLAG = 0;
		J9VMCONSTANTPOOL_JAVALANGSTRING_VALUE = 0;
		J9VMCONSTANTPOOL_JAVALANGSYSTEM = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADDEATH = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_ISDAEMON = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_MAXPRIORITY = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREADGROUP_PARENT = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_CONTEXTCLASSLOADER = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_INIT = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_LOCK = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_NAME = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_PARKBLOCKER = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_STARTED = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_THREADREF = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_TID = 0;
		J9VMCONSTANTPOOL_JAVALANGTHREAD_UNCAUGHTEXCEPTION = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_DETAILMESSAGE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_STACKTRACE = 0;
		J9VMCONSTANTPOOL_JAVALANGTHROWABLE_WALKBACK = 0;
		J9VMCONSTANTPOOL_JAVALANGUNSATISFIEDLINKERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGUNSUPPORTEDCLASSVERSIONERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGVERIFYERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGVIRTUALMACHINEERROR = 0;
		J9VMCONSTANTPOOL_JAVALANGVOID = 0;
		J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER = 0;
		J9VMCONSTANTPOOL_JAVAUTILCONCURRENTLOCKSABSTRACTOWNABLESYNCHRONIZER_EXCLUSIVEOWNERTHREAD = 0;
		J9VM_VMCONSTANTPOOL_SIZE = 0;
		JCL_RTFLAG_DEFAULT = 0;
		JCL_RTFLAG_INTERP_HOT_CODE_REPLACEMENT = 0;
		JCL_RTFLAG_JIT_NEW_INSTANCE_PROTOTYPE = 0;
		JCL_RTFLAG_OPT_METHOD_HANDLE = 0;
		JCL_RTFLAG_OPT_REFLECT = 0;
	}

}
