/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: JvmriConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class JvmriConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long GC_THREAD_SUSPEND;
	public static final long JVMRAS_VERSION_1_1;
	public static final long JVMRAS_VERSION_1_3;
	public static final long JVMRAS_VERSION_1_5;
	public static final long NO_GC_THREAD_SUSPEND;
	public static final long RASINFO_MAX_TYPES;
	public static final long RASINFO_TRACE_COMPONENT;
	public static final long RASINFO_TRACE_COMPONENTS;
	public static final long RASINFO_TYPES;
	public static final long RAS_DUMP_ABORT;
	public static final long RAS_DUMP_CONTINUE;
	public static final long RAS_THREAD_NAME_SIZE;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		GC_THREAD_SUSPEND = 0;
		JVMRAS_VERSION_1_1 = 0;
		JVMRAS_VERSION_1_3 = 0;
		JVMRAS_VERSION_1_5 = 0;
		NO_GC_THREAD_SUSPEND = 0;
		RASINFO_MAX_TYPES = 0;
		RASINFO_TRACE_COMPONENT = 0;
		RASINFO_TRACE_COMPONENTS = 0;
		RASINFO_TYPES = 0;
		RAS_DUMP_ABORT = 0;
		RAS_DUMP_CONTINUE = 0;
		RAS_THREAD_NAME_SIZE = 0;
	}

}
