/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ModronConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ModronConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9GC_COMPRESSED_POINTER_NULL_REGION_SIZE;
	public static final long J9GC_HEAP_EXPAND_FLAGS_FREE_LIST;
	public static final long J9GC_HEAP_EXPAND_FLAGS_MERGEABLE;
	public static final long J9GC_HEAP_EXPAND_FLAGS_NO_MINIMUM;
	public static final long J9GC_HEAP_EXPAND_RESULT_INSUFFICIENT_VMEM;
	public static final long J9GC_HEAP_EXPAND_RESULT_OK;
	public static final long J9GC_HEAP_EXPAND_RESULT_OUT_OF_MEMORY;
	public static final long J9GC_REMEMBERED_SET_RESERVED_INDEX;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9GC_COMPRESSED_POINTER_NULL_REGION_SIZE = 0;
		J9GC_HEAP_EXPAND_FLAGS_FREE_LIST = 0;
		J9GC_HEAP_EXPAND_FLAGS_MERGEABLE = 0;
		J9GC_HEAP_EXPAND_FLAGS_NO_MINIMUM = 0;
		J9GC_HEAP_EXPAND_RESULT_INSUFFICIENT_VMEM = 0;
		J9GC_HEAP_EXPAND_RESULT_OK = 0;
		J9GC_HEAP_EXPAND_RESULT_OUT_OF_MEMORY = 0;
		J9GC_REMEMBERED_SET_RESERVED_INDEX = 0;
	}

}
