/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.systemd;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.internal.platform.Metrics;
import jdk.test.lib.Platform;
import jdk.test.lib.Utils;
import jdk.test.lib.containers.systemd.SystemdRunOptions;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.util.FileUtils;
import jtreg.SkippedException;

public class SystemdTestUtils {
    private static final String CGROUPS_PROVIDER = Metrics.systemMetrics().getProvider();
    private static boolean CGROUPS_V2 = "cgroupv2".equals(CGROUPS_PROVIDER);
    public static boolean RUN_AS_USER = !Platform.isRoot() && CGROUPS_V2;
    private static final String SLICE_NAMESPACE_PREFIX = "jdk_internal";
    private static final String SLICE_D_MEM_CONFIG_FILE = "memory-limit.conf";
    private static final String SLICE_D_CPU_CONFIG_FILE = "cpu-limit.conf";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final Path SYSTEMD_CONFIG_HOME_ROOT = Path.of("/", "etc", "systemd", "system");
    private static final Path SYSTEMD_CONFIG_HOME_USER = Path.of(USER_HOME, ".config", "systemd", "user");
    private static final Path SYSTEMD_CONFIG_HOME = Platform.isRoot() ? SYSTEMD_CONFIG_HOME_ROOT : SYSTEMD_CONFIG_HOME_USER;
    private static final int MAX_LINES_TO_COPY_FOR_CHILD_STDOUT = 100;

    public static SystemdRunOptions newOpts(String testClass) {
        return new SystemdRunOptions(testClass, "-Xlog:os+container=trace", "-cp", Utils.TEST_CLASSES);
    }

    public static OutputAnalyzer buildAndRunSystemdJava(SystemdRunOptions opts) throws Exception, SkippedException {
        if (!Platform.isRoot() && !CGROUPS_V2) {
            throw new SkippedException("Systemd tests require root on cgroup v1. Test skipped!");
        }
        ResultFiles files = SystemdTestUtils.buildSystemdSlices(opts);
        try {
            OutputAnalyzer outputAnalyzer = SystemdTestUtils.systemdRunJava(opts);
            return outputAnalyzer;
        }
        finally {
            SystemdTestUtils.cleanupFiles(files);
        }
    }

    private static void cleanupFiles(ResultFiles files) throws IOException {
        try {
            if (files.memory() != null) {
                Files.delete(files.memory());
            }
            if (files.cpu() != null) {
                Files.delete(files.cpu());
            }
            if (files.sliceDotDDir() != null) {
                FileUtils.deleteFileTreeUnchecked(files.sliceDotDDir());
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static OutputAnalyzer systemdRunJava(SystemdRunOptions opts) throws Exception {
        return SystemdTestUtils.execute(SystemdTestUtils.buildJavaCommand(opts));
    }

    private static ResultFiles buildSystemdSlices(SystemdRunOptions runOpts) throws Exception {
        Path cpu;
        Path memory;
        String sliceName = SystemdTestUtils.sliceName(runOpts);
        String sliceNameCpu = SystemdTestUtils.sliceNameCpu(runOpts);
        String memorySliceContent = SystemdTestUtils.getMemorySlice(runOpts, sliceName);
        String cpuSliceContent = SystemdTestUtils.getCpuSlice(runOpts, sliceName);
        Files.createDirectories(SYSTEMD_CONFIG_HOME, new FileAttribute[0]);
        Path sliceDotDDir = null;
        if (runOpts.hasSliceDLimit()) {
            String dirName = String.format("%s.slice.d", SLICE_NAMESPACE_PREFIX);
            sliceDotDDir = SYSTEMD_CONFIG_HOME.resolve(Path.of(dirName, new String[0]));
            Files.createDirectories(sliceDotDDir, new FileAttribute[0]);
            if (runOpts.sliceDMemoryLimit != null) {
                Path memoryConfig = sliceDotDDir.resolve(Path.of(SLICE_D_MEM_CONFIG_FILE, new String[0]));
                Files.writeString(memoryConfig, (CharSequence)SystemdTestUtils.getMemoryDSliceContent(runOpts), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            if (runOpts.sliceDCpuLimit != null) {
                Path cpuConfig = sliceDotDDir.resolve(Path.of(SLICE_D_CPU_CONFIG_FILE, new String[0]));
                Files.writeString(cpuConfig, (CharSequence)SystemdTestUtils.getCPUDSliceContent(runOpts), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
        }
        try {
            memory = SYSTEMD_CONFIG_HOME.resolve(Path.of(SystemdTestUtils.sliceFileName(sliceName), new String[0]));
            cpu = SYSTEMD_CONFIG_HOME.resolve(Path.of(SystemdTestUtils.sliceFileName(sliceNameCpu), new String[0]));
            Files.writeString(memory, (CharSequence)memorySliceContent, new OpenOption[0]);
            Files.writeString(cpu, (CharSequence)cpuSliceContent, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Failed to write systemd slice files");
        }
        SystemdTestUtils.systemdDaemonReload(cpu, memory, sliceDotDDir);
        return new ResultFiles(memory, cpu, sliceDotDDir);
    }

    private static String sliceName(SystemdRunOptions runOpts) {
        return "jdk_internal-" + runOpts.sliceName.replace("-", "_");
    }

    private static String sliceNameCpu(SystemdRunOptions runOpts) {
        String slice = SystemdTestUtils.sliceName(runOpts);
        return String.format("%s-cpu", slice);
    }

    private static void systemdDaemonReload(Path cpu, Path memory, Path sliceDdir) throws Exception {
        List<String> daemonReload = SystemdTestUtils.systemCtl();
        daemonReload.add("daemon-reload");
        if (SystemdTestUtils.execute(daemonReload).getExitValue() != 0) {
            if (RUN_AS_USER) {
                SystemdTestUtils.cleanupFiles(new ResultFiles(cpu, memory, sliceDdir));
                String msg = "Service user@.service not properly configured. Skipping the test!";
                throw new SkippedException(msg);
            }
            throw new AssertionError((Object)"Failed to reload systemd daemon");
        }
    }

    private static List<String> systemCtl() {
        return SystemdTestUtils.commandWithUser("systemctl");
    }

    private static List<String> commandWithUser(String baseCommand) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(baseCommand);
        if (RUN_AS_USER) {
            command.add("--user");
        }
        return command;
    }

    private static String getCpuSlice(SystemdRunOptions runOpts, String sliceName) {
        String basicSliceFormat = SystemdTestUtils.getBasicSliceFormat();
        return String.format(basicSliceFormat, sliceName, SystemdTestUtils.getCPUSliceContent(runOpts));
    }

    private static String getCPUSliceContent(SystemdRunOptions runOpts) {
        String format = SystemdTestUtils.basicCPUContentFormat();
        return String.format(format, runOpts.cpuLimit);
    }

    private static String getMemorySlice(SystemdRunOptions runOpts, String sliceName) {
        String basicSliceFormat = SystemdTestUtils.getBasicSliceFormat();
        return String.format(basicSliceFormat, sliceName, SystemdTestUtils.getMemorySliceContent(runOpts));
    }

    private static String getMemoryDSliceContent(SystemdRunOptions runOpts) {
        String format = "[Slice]\n" + SystemdTestUtils.basicMemoryContentFormat();
        return String.format(format, runOpts.sliceDMemoryLimit);
    }

    private static String getCPUDSliceContent(SystemdRunOptions runOpts) {
        String format = "[Slice]\n" + SystemdTestUtils.basicCPUContentFormat();
        return String.format(format, runOpts.sliceDCpuLimit);
    }

    private static String basicCPUContentFormat() {
        return "CPUAccounting=true\nCPUQuota=%s\n";
    }

    private static String basicMemoryContentFormat() {
        return "MemoryAccounting=true\nMemoryLimit=%s\n";
    }

    private static String getMemorySliceContent(SystemdRunOptions runOpts) {
        String format = SystemdTestUtils.basicMemoryContentFormat();
        return String.format(format, runOpts.memoryLimit);
    }

    private static String getBasicSliceFormat() {
        return "[Unit]\nDescription=OpenJDK Tests Slice for %s\nBefore=slices.target\n\n[Slice]\n%s\n";
    }

    private static String sliceFileName(String sliceName) {
        return String.format("%s.slice", sliceName);
    }

    private static List<String> buildJavaCommand(SystemdRunOptions opts) throws Exception {
        List<String> javaCmd = SystemdTestUtils.systemdRun();
        javaCmd.add("--slice");
        javaCmd.add(SystemdTestUtils.sliceFileName(SystemdTestUtils.sliceNameCpu(opts)));
        javaCmd.add("--scope");
        javaCmd.add(Path.of(Utils.TEST_JDK, "bin", "java").toString());
        javaCmd.addAll(opts.javaOpts);
        javaCmd.add(opts.classToRun);
        javaCmd.addAll(opts.classParams);
        return javaCmd;
    }

    private static List<String> systemdRun() {
        return SystemdTestUtils.commandWithUser("systemd-run");
    }

    private static OutputAnalyzer execute(List<String> command) throws Exception {
        return SystemdTestUtils.execute((String[])command.toArray(String[]::new));
    }

    private static OutputAnalyzer execute(String ... command) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(command);
        System.out.println("[COMMAND]\n" + Utils.getCommandLine(pb));
        Process p = pb.start();
        long pid = p.pid();
        OutputAnalyzer output = new OutputAnalyzer(p);
        int max = 100;
        String stdout = output.getStdout();
        String stdoutLimited = SystemdTestUtils.limitLines(stdout, max);
        System.out.println("[STDERR]\n" + output.getStderr());
        System.out.println("[STDOUT]\n" + stdoutLimited);
        if (stdout != stdoutLimited) {
            System.out.printf("Child process STDOUT is limited to %d lines\n", max);
        }
        String stdoutLogFile = String.format("systemd-stdout-%d.log", pid);
        SystemdTestUtils.writeOutputToFile(stdout, stdoutLogFile);
        System.out.println("Full child process STDOUT was saved to " + stdoutLogFile);
        return output;
    }

    private static void writeOutputToFile(String output, String fileName) throws Exception {
        try (FileWriter fw = new FileWriter(fileName);){
            fw.write(output, 0, output.length());
        }
    }

    private static String limitLines(String buffer, int nrOfLines) {
        List<String> l = Arrays.asList(buffer.split("\\R"));
        if (l.size() < nrOfLines) {
            return buffer;
        }
        return String.join((CharSequence)"\n", l.subList(0, nrOfLines));
    }

    public record ResultFiles(Path memory, Path cpu, Path sliceDotDDir) {
    }
}

