/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import jdk.test.lib.Asserts;

public class RecurseThread
extends Thread {
    public int totalDepth;
    public long dummy = 0L;
    private volatile boolean timeToQuit = false;
    private volatile boolean isInRunLoop = false;

    public RecurseThread(int totalDepth) {
        this.totalDepth = totalDepth;
    }

    @Override
    public void run() {
        int minDepth = 3;
        Asserts.assertGreaterThanOrEqual(this.totalDepth, 3, "totalDepth too small");
        int recurseDepth = this.totalDepth - 3;
        boolean startWithRecurseA = this.totalDepth % 2 != 0;
        this.dummy = startWithRecurseA ? this.recurseA(recurseDepth) : this.recurseB(recurseDepth);
    }

    public void quit() {
        this.timeToQuit = true;
    }

    public boolean isInRunLoop() {
        return this.isInRunLoop;
    }

    private long recurseA(int depth) {
        if (depth == 0) {
            return this.recurseEnd();
        }
        return this.recurseB(depth - 1);
    }

    private long recurseB(int depth) {
        if (depth == 0) {
            return this.recurseEnd();
        }
        return this.recurseA(depth - 1);
    }

    private long recurseEnd() {
        this.isInRunLoop = true;
        long[] dummyTable = new long[]{0L, 2L, 4L, 8L, 16L};
        long dummyTotal = 0L;
        while (!this.timeToQuit) {
            dummyTotal = 0L;
            for (int i = 0; i < 5; ++i) {
                dummyTotal += dummyTable[i];
            }
        }
        return dummyTotal;
    }
}

