/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security.timestamp;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import jdk.test.lib.security.timestamp.TsaHandler;

public class TsaServer
implements AutoCloseable {
    private final HttpServer server;

    public TsaServer(int port, TsaHandler handler) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        if (handler != null) {
            this.setHandler(handler);
        }
    }

    public TsaServer(int port) throws IOException {
        this(port, null);
    }

    public TsaServer(int port, KeyStore keyStore, String passphrase) throws IOException {
        this(port, new TsaHandler(keyStore, passphrase));
    }

    public final void setHandler(TsaHandler handler) {
        this.server.createContext("/", handler);
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop(0);
    }

    public int getPort() {
        return this.server.getAddress().getPort();
    }

    @Override
    public void close() {
        this.stop();
    }
}

