/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.util;

import jdk.test.lib.hprof.util.Comparer;

public class ArraySorter {
    public static void sort(Object[] arr, Comparer c) {
        ArraySorter.quickSort(arr, c, 0, arr.length - 1);
    }

    public static void sortArrayOfStrings(Object[] arr) {
        ArraySorter.sort(arr, new Comparer(){

            @Override
            public int compare(Object lhs, Object rhs) {
                return ((String)lhs).compareTo((String)rhs);
            }
        });
    }

    private static void swap(Object[] arr, int a, int b) {
        Object tmp = arr[a];
        arr[a] = arr[b];
        arr[b] = tmp;
    }

    private static void quickSort(Object[] arr, Comparer c, int from, int to) {
        if (to <= from) {
            return;
        }
        int mid = (from + to) / 2;
        if (mid != from) {
            ArraySorter.swap(arr, mid, from);
        }
        Object pivot = arr[from];
        int highestBelowPivot = from - 1;
        int low = from + 1;
        int high = to;
        while (low <= high) {
            int c2;
            int cmp = c.compare(arr[low], pivot);
            if (cmp <= 0) {
                if (cmp < 0) {
                    highestBelowPivot = low;
                }
                ++low;
                continue;
            }
            while ((c2 = c.compare(arr[high], pivot)) > 0 && low <= --high) {
            }
            if (low > high) continue;
            ArraySorter.swap(arr, low, high);
            if (c2 < 0) {
                highestBelowPivot = low;
            }
            ++low;
            --high;
        }
        if (highestBelowPivot > from) {
            ArraySorter.swap(arr, from, highestBelowPivot);
            ArraySorter.quickSort(arr, c, from, highestBelowPivot - 1);
        }
        ArraySorter.quickSort(arr, c, high + 1, to);
    }
}

