/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: statvfs
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class statvfs {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _f_bavailOffset_;
	public static final int _f_bfreeOffset_;
	public static final int _f_blocksOffset_;
	public static final int _f_bsizeOffset_;
	public static final int _f_favailOffset_;
	public static final int _f_ffreeOffset_;
	public static final int _f_filesOffset_;
	public static final int _f_flagOffset_;
	public static final int _f_frsizeOffset_;
	public static final int _f_fsidOffset_;
	public static final int _f_namemaxOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_f_bavailOffset_ = 0;
		_f_bfreeOffset_ = 0;
		_f_blocksOffset_ = 0;
		_f_bsizeOffset_ = 0;
		_f_favailOffset_ = 0;
		_f_ffreeOffset_ = 0;
		_f_filesOffset_ = 0;
		_f_flagOffset_ = 0;
		_f_frsizeOffset_ = 0;
		_f_fsidOffset_ = 0;
		_f_namemaxOffset_ = 0;
	}

}
