/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_CycleStateVLHGCPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_CycleStateVLHGCPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_CycleStateVLHGC.class)
public class MM_CycleStateVLHGCPointer extends MM_CycleStatePointer {

	// NULL
	public static final MM_CycleStateVLHGCPointer NULL = new MM_CycleStateVLHGCPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_CycleStateVLHGCPointer(long address) {
		super(address);
	}

	public static MM_CycleStateVLHGCPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_CycleStateVLHGCPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_CycleStateVLHGCPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_CycleStateVLHGCPointer(address);
	}

	public MM_CycleStateVLHGCPointer add(long count) {
		return MM_CycleStateVLHGCPointer.cast(address + (MM_CycleStateVLHGC.SIZEOF * count));
	}

	public MM_CycleStateVLHGCPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_CycleStateVLHGCPointer addOffset(long offset) {
		return MM_CycleStateVLHGCPointer.cast(address + offset);
	}

	public MM_CycleStateVLHGCPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_CycleStateVLHGCPointer sub(long count) {
		return MM_CycleStateVLHGCPointer.cast(address - (MM_CycleStateVLHGC.SIZEOF * count));
	}

	public MM_CycleStateVLHGCPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_CycleStateVLHGCPointer subOffset(long offset) {
		return MM_CycleStateVLHGCPointer.cast(address - offset);
	}

	public MM_CycleStateVLHGCPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_CycleStateVLHGCPointer untag(long mask) {
		return MM_CycleStateVLHGCPointer.cast(address & ~mask);
	}

	public MM_CycleStateVLHGCPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_CycleStateVLHGC.SIZEOF;
	}

	// Implementation methods

	// bool _abortFlagRaisedDuringPGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__abortFlagRaisedDuringPGCOffset_", declaredType="bool")
	public boolean _abortFlagRaisedDuringPGC() throws CorruptDataException {
		return getBoolAtOffset(MM_CycleStateVLHGC.__abortFlagRaisedDuringPGCOffset_);
	}

	// bool _abortFlagRaisedDuringPGC
	public BoolPointer _abortFlagRaisedDuringPGCEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__abortFlagRaisedDuringPGCOffset_));
	}

	// U64 _desiredCompactWork
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__desiredCompactWorkOffset_", declaredType="U64")
	public UDATA _desiredCompactWork() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_CycleStateVLHGC.__desiredCompactWorkOffset_));
	}

	// U64 _desiredCompactWork
	public UDATAPointer _desiredCompactWorkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__desiredCompactWorkOffset_));
	}

	// MM_SchedulingDelegate* _schedulingDelegate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__schedulingDelegateOffset_", declaredType="MM_SchedulingDelegate*")
	public MM_SchedulingDelegatePointer _schedulingDelegate() throws CorruptDataException {
		return MM_SchedulingDelegatePointer.cast(getPointerAtOffset(MM_CycleStateVLHGC.__schedulingDelegateOffset_));
	}

	// MM_SchedulingDelegate* _schedulingDelegate
	public PointerPointer _schedulingDelegateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__schedulingDelegateOffset_));
	}

	// bool _useSlidingCompactor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__useSlidingCompactorOffset_", declaredType="bool")
	public boolean _useSlidingCompactor() throws CorruptDataException {
		return getBoolAtOffset(MM_CycleStateVLHGC.__useSlidingCompactorOffset_);
	}

	// bool _useSlidingCompactor
	public BoolPointer _useSlidingCompactorEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__useSlidingCompactorOffset_));
	}

	// MM_VLHGCCycleStats _vlhgcCycleStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vlhgcCycleStatsOffset_", declaredType="MM_VLHGCCycleStats")
	public MM_VLHGCCycleStatsPointer _vlhgcCycleStats() throws CorruptDataException {
		return MM_VLHGCCycleStatsPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__vlhgcCycleStatsOffset_));
	}

	// MM_VLHGCCycleStats _vlhgcCycleStats
	public PointerPointer _vlhgcCycleStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__vlhgcCycleStatsOffset_));
	}

	// MM_VLHGCIncrementStats _vlhgcIncrementStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vlhgcIncrementStatsOffset_", declaredType="MM_VLHGCIncrementStats")
	public MM_VLHGCIncrementStatsPointer _vlhgcIncrementStats() throws CorruptDataException {
		return MM_VLHGCIncrementStatsPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__vlhgcIncrementStatsOffset_));
	}

	// MM_VLHGCIncrementStats _vlhgcIncrementStats
	public PointerPointer _vlhgcIncrementStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_CycleStateVLHGC.__vlhgcIncrementStatsOffset_));
	}

}
