/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_ConcurrentMarkPhaseStatsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_ConcurrentMarkPhaseStatsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_ConcurrentMarkPhaseStats.class)
public class MM_ConcurrentMarkPhaseStatsPointer extends MM_ConcurrentPhaseStatsBasePointer {

	// NULL
	public static final MM_ConcurrentMarkPhaseStatsPointer NULL = new MM_ConcurrentMarkPhaseStatsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_ConcurrentMarkPhaseStatsPointer(long address) {
		super(address);
	}

	public static MM_ConcurrentMarkPhaseStatsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_ConcurrentMarkPhaseStatsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_ConcurrentMarkPhaseStatsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_ConcurrentMarkPhaseStatsPointer(address);
	}

	public MM_ConcurrentMarkPhaseStatsPointer add(long count) {
		return MM_ConcurrentMarkPhaseStatsPointer.cast(address + (MM_ConcurrentMarkPhaseStats.SIZEOF * count));
	}

	public MM_ConcurrentMarkPhaseStatsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_ConcurrentMarkPhaseStatsPointer addOffset(long offset) {
		return MM_ConcurrentMarkPhaseStatsPointer.cast(address + offset);
	}

	public MM_ConcurrentMarkPhaseStatsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_ConcurrentMarkPhaseStatsPointer sub(long count) {
		return MM_ConcurrentMarkPhaseStatsPointer.cast(address - (MM_ConcurrentMarkPhaseStats.SIZEOF * count));
	}

	public MM_ConcurrentMarkPhaseStatsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_ConcurrentMarkPhaseStatsPointer subOffset(long offset) {
		return MM_ConcurrentMarkPhaseStatsPointer.cast(address - offset);
	}

	public MM_ConcurrentMarkPhaseStatsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_ConcurrentMarkPhaseStatsPointer untag(long mask) {
		return MM_ConcurrentMarkPhaseStatsPointer.cast(address & ~mask);
	}

	public MM_ConcurrentMarkPhaseStatsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_ConcurrentMarkPhaseStats.SIZEOF;
	}

	// Implementation methods

	// MM_ConcurrentCardTableStats* _cardTableStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cardTableStatsOffset_", declaredType="MM_ConcurrentCardTableStats*")
	public MM_ConcurrentCardTableStatsPointer _cardTableStats() throws CorruptDataException {
		return MM_ConcurrentCardTableStatsPointer.cast(getPointerAtOffset(MM_ConcurrentMarkPhaseStats.__cardTableStatsOffset_));
	}

	// MM_ConcurrentCardTableStats* _cardTableStats
	public PointerPointer _cardTableStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ConcurrentMarkPhaseStats.__cardTableStatsOffset_));
	}

	// MM_ConcurrentGCStats* _collectionStats
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__collectionStatsOffset_", declaredType="MM_ConcurrentGCStats*")
	public MM_ConcurrentGCStatsPointer _collectionStats() throws CorruptDataException {
		return MM_ConcurrentGCStatsPointer.cast(getPointerAtOffset(MM_ConcurrentMarkPhaseStats.__collectionStatsOffset_));
	}

	// MM_ConcurrentGCStats* _collectionStats
	public PointerPointer _collectionStatsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ConcurrentMarkPhaseStats.__collectionStatsOffset_));
	}

}
