/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.process;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import jdk.test.lib.process.StreamPumper;

public interface OutputBuffer {
    public void waitFor();

    public String getStdout();

    default public List<String> getStdoutAsList() {
        return new BufferedReader(new StringReader(this.getStdout())).lines().collect(Collectors.toList());
    }

    public String getStderr();

    public int getExitValue();

    public long pid();

    public static OutputBuffer of(Process p, Charset cs) {
        return new LazyOutputBuffer(p, cs);
    }

    public static OutputBuffer of(Process p) {
        return new LazyOutputBuffer(p, null);
    }

    public static OutputBuffer of(String stdout, String stderr, int exitValue) {
        return new EagerOutputBuffer(stdout, stderr, exitValue);
    }

    public static OutputBuffer of(String stdout, String stderr) {
        return OutputBuffer.of(stdout, stderr, -1);
    }

    public static class LazyOutputBuffer
    implements OutputBuffer {
        private final StreamTask outTask;
        private final StreamTask errTask;
        private final Process p;
        private volatile Integer exitValue;

        private final void logProgress(String state) {
            System.out.println("[" + Instant.now().toString() + "] " + state + " for process " + this.p.pid());
            System.out.flush();
        }

        private LazyOutputBuffer(Process p, Charset cs) {
            this.p = p;
            this.logProgress("Gathering output");
            this.outTask = new StreamTask(p.getInputStream(), cs);
            this.errTask = new StreamTask(p.getErrorStream(), cs);
        }

        @Override
        public void waitFor() {
            if (this.exitValue != null) {
                return;
            }
            try {
                this.logProgress("Waiting for completion");
                boolean aborted = true;
                try {
                    this.exitValue = this.p.waitFor();
                    this.logProgress("Waiting for completion finished");
                    aborted = false;
                }
                finally {
                    if (aborted) {
                        this.logProgress("Waiting for completion FAILED");
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new OutputBufferException(e);
            }
        }

        @Override
        public String getStdout() {
            return this.outTask.get();
        }

        @Override
        public String getStderr() {
            return this.errTask.get();
        }

        @Override
        public int getExitValue() {
            this.waitFor();
            return this.exitValue;
        }

        @Override
        public long pid() {
            return this.p.pid();
        }

        private static class StreamTask {
            private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            private final Future<Void> future;
            private final Charset cs;

            private StreamTask(InputStream stream, Charset cs) {
                this.cs = cs;
                this.future = new StreamPumper(stream, this.buffer).process();
            }

            public String get() {
                try {
                    this.future.get();
                    return this.cs == null ? this.buffer.toString() : this.buffer.toString(this.cs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OutputBufferException(e);
                }
                catch (CancellationException | ExecutionException e) {
                    throw new OutputBufferException(e);
                }
            }
        }
    }

    public static class EagerOutputBuffer
    implements OutputBuffer {
        private final String stdout;
        private final String stderr;
        private final int exitValue;

        private EagerOutputBuffer(String stdout, String stderr, int exitValue) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.exitValue = exitValue;
        }

        @Override
        public void waitFor() {
        }

        @Override
        public String getStdout() {
            return this.stdout;
        }

        @Override
        public String getStderr() {
            return this.stderr;
        }

        @Override
        public int getExitValue() {
            return this.exitValue;
        }

        @Override
        public long pid() {
            throw new RuntimeException("no process");
        }
    }

    public static class OutputBufferException
    extends RuntimeException {
        private static final long serialVersionUID = 8528687792643129571L;

        public OutputBufferException(Throwable cause) {
            super(cause);
        }
    }
}

