/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MeteringHistoryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MeteringHistoryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MeteringHistory.class)
public class MeteringHistoryPointer extends StructurePointer {

	// NULL
	public static final MeteringHistoryPointer NULL = new MeteringHistoryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MeteringHistoryPointer(long address) {
		super(address);
	}

	public static MeteringHistoryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MeteringHistoryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MeteringHistoryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MeteringHistoryPointer(address);
	}

	public MeteringHistoryPointer add(long count) {
		return MeteringHistoryPointer.cast(address + (MeteringHistory.SIZEOF * count));
	}

	public MeteringHistoryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MeteringHistoryPointer addOffset(long offset) {
		return MeteringHistoryPointer.cast(address + offset);
	}

	public MeteringHistoryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MeteringHistoryPointer sub(long count) {
		return MeteringHistoryPointer.cast(address - (MeteringHistory.SIZEOF * count));
	}

	public MeteringHistoryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MeteringHistoryPointer subOffset(long offset) {
		return MeteringHistoryPointer.cast(address - offset);
	}

	public MeteringHistoryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MeteringHistoryPointer untag(long mask) {
		return MeteringHistoryPointer.cast(address & ~mask);
	}

	public MeteringHistoryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MeteringHistory.SIZEOF;
	}

	// Implementation methods

	// U64 loaFreeAfterGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loaFreeAfterGCOffset_", declaredType="U64")
	public UDATA loaFreeAfterGC() throws CorruptDataException {
		return new U64(getLongAtOffset(MeteringHistory._loaFreeAfterGCOffset_));
	}

	// U64 loaFreeAfterGC
	public UDATAPointer loaFreeAfterGCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MeteringHistory._loaFreeAfterGCOffset_));
	}

	// U64 loaFreeBeforeGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_loaFreeBeforeGCOffset_", declaredType="U64")
	public UDATA loaFreeBeforeGC() throws CorruptDataException {
		return new U64(getLongAtOffset(MeteringHistory._loaFreeBeforeGCOffset_));
	}

	// U64 loaFreeBeforeGC
	public UDATAPointer loaFreeBeforeGCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MeteringHistory._loaFreeBeforeGCOffset_));
	}

	// U64 soaFreeAfterGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_soaFreeAfterGCOffset_", declaredType="U64")
	public UDATA soaFreeAfterGC() throws CorruptDataException {
		return new U64(getLongAtOffset(MeteringHistory._soaFreeAfterGCOffset_));
	}

	// U64 soaFreeAfterGC
	public UDATAPointer soaFreeAfterGCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MeteringHistory._soaFreeAfterGCOffset_));
	}

	// U64 soaFreeBeforeGC
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_soaFreeBeforeGCOffset_", declaredType="U64")
	public UDATA soaFreeBeforeGC() throws CorruptDataException {
		return new U64(getLongAtOffset(MeteringHistory._soaFreeBeforeGCOffset_));
	}

	// U64 soaFreeBeforeGC
	public UDATAPointer soaFreeBeforeGCEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MeteringHistory._soaFreeBeforeGCOffset_));
	}

	// MeteringVote vote
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_voteOffset_", declaredType="MeteringVote")
	public long vote() throws CorruptDataException {
		if (MeteringVote.SIZEOF == 1) {
			return getByteAtOffset(MeteringHistory._voteOffset_);
		} else if (MeteringVote.SIZEOF == 2) {
			return getShortAtOffset(MeteringHistory._voteOffset_);
		} else if (MeteringVote.SIZEOF == 4) {
			return getIntAtOffset(MeteringHistory._voteOffset_);
		} else if (MeteringVote.SIZEOF == 8) {
			return getLongAtOffset(MeteringHistory._voteOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MeteringVote vote
	public EnumPointer voteEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(MeteringHistory._voteOffset_), MeteringVote.class);
	}

}
