/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: UserSpecifiedParametersPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the UserSpecifiedParametersPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=UserSpecifiedParameters.class)
public class UserSpecifiedParametersPointer extends StructurePointer {

	// NULL
	public static final UserSpecifiedParametersPointer NULL = new UserSpecifiedParametersPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected UserSpecifiedParametersPointer(long address) {
		super(address);
	}

	public static UserSpecifiedParametersPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static UserSpecifiedParametersPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static UserSpecifiedParametersPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new UserSpecifiedParametersPointer(address);
	}

	public UserSpecifiedParametersPointer add(long count) {
		return UserSpecifiedParametersPointer.cast(address + (UserSpecifiedParameters.SIZEOF * count));
	}

	public UserSpecifiedParametersPointer add(Scalar count) {
		return add(count.longValue());
	}

	public UserSpecifiedParametersPointer addOffset(long offset) {
		return UserSpecifiedParametersPointer.cast(address + offset);
	}

	public UserSpecifiedParametersPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public UserSpecifiedParametersPointer sub(long count) {
		return UserSpecifiedParametersPointer.cast(address - (UserSpecifiedParameters.SIZEOF * count));
	}

	public UserSpecifiedParametersPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public UserSpecifiedParametersPointer subOffset(long offset) {
		return UserSpecifiedParametersPointer.cast(address - offset);
	}

	public UserSpecifiedParametersPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public UserSpecifiedParametersPointer untag(long mask) {
		return UserSpecifiedParametersPointer.cast(address & ~mask);
	}

	public UserSpecifiedParametersPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return UserSpecifiedParameters.SIZEOF;
	}

	// Implementation methods

	// MM_UserSpecifiedParameterUDATA _Xmn
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__XmnOffset_", declaredType="MM_UserSpecifiedParameterUDATA")
	public MM_UserSpecifiedParameterUDATAPointer _Xmn() throws CorruptDataException {
		return MM_UserSpecifiedParameterUDATAPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmnOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmn
	public PointerPointer _XmnEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmnOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmns
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__XmnsOffset_", declaredType="MM_UserSpecifiedParameterUDATA")
	public MM_UserSpecifiedParameterUDATAPointer _Xmns() throws CorruptDataException {
		return MM_UserSpecifiedParameterUDATAPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmnsOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmns
	public PointerPointer _XmnsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmnsOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmnx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__XmnxOffset_", declaredType="MM_UserSpecifiedParameterUDATA")
	public MM_UserSpecifiedParameterUDATAPointer _Xmnx() throws CorruptDataException {
		return MM_UserSpecifiedParameterUDATAPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmnxOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmnx
	public PointerPointer _XmnxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmnxOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__XmxOffset_", declaredType="MM_UserSpecifiedParameterUDATA")
	public MM_UserSpecifiedParameterUDATAPointer _Xmx() throws CorruptDataException {
		return MM_UserSpecifiedParameterUDATAPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmxOffset_));
	}

	// MM_UserSpecifiedParameterUDATA _Xmx
	public PointerPointer _XmxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(UserSpecifiedParameters.__XmxOffset_));
	}

}
