/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: VM_JFRChunkWriterPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the VM_JFRChunkWriterPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=VM_JFRChunkWriter.class)
public class VM_JFRChunkWriterPointer extends StructurePointer {

	// NULL
	public static final VM_JFRChunkWriterPointer NULL = new VM_JFRChunkWriterPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected VM_JFRChunkWriterPointer(long address) {
		super(address);
	}

	public static VM_JFRChunkWriterPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static VM_JFRChunkWriterPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static VM_JFRChunkWriterPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new VM_JFRChunkWriterPointer(address);
	}

	public VM_JFRChunkWriterPointer add(long count) {
		return VM_JFRChunkWriterPointer.cast(address + (VM_JFRChunkWriter.SIZEOF * count));
	}

	public VM_JFRChunkWriterPointer add(Scalar count) {
		return add(count.longValue());
	}

	public VM_JFRChunkWriterPointer addOffset(long offset) {
		return VM_JFRChunkWriterPointer.cast(address + offset);
	}

	public VM_JFRChunkWriterPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public VM_JFRChunkWriterPointer sub(long count) {
		return VM_JFRChunkWriterPointer.cast(address - (VM_JFRChunkWriter.SIZEOF * count));
	}

	public VM_JFRChunkWriterPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public VM_JFRChunkWriterPointer subOffset(long offset) {
		return VM_JFRChunkWriterPointer.cast(address - offset);
	}

	public VM_JFRChunkWriterPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public VM_JFRChunkWriterPointer untag(long mask) {
		return VM_JFRChunkWriterPointer.cast(address & ~mask);
	}

	public VM_JFRChunkWriterPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return VM_JFRChunkWriter.SIZEOF;
	}

	// Implementation methods

	// VM_BufferWriter* _bufferWriter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferWriterOffset_", declaredType="VM_BufferWriter*")
	public VM_BufferWriterPointer _bufferWriter() throws CorruptDataException {
		return VM_BufferWriterPointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__bufferWriterOffset_));
	}

	// VM_BufferWriter* _bufferWriter
	public PointerPointer _bufferWriterEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__bufferWriterOffset_));
	}

	// JfrBuildResult _buildResult
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__buildResultOffset_", declaredType="JfrBuildResult")
	public long _buildResult() throws CorruptDataException {
		if (JfrBuildResult.SIZEOF == 1) {
			return getByteAtOffset(VM_JFRChunkWriter.__buildResultOffset_);
		} else if (JfrBuildResult.SIZEOF == 2) {
			return getShortAtOffset(VM_JFRChunkWriter.__buildResultOffset_);
		} else if (JfrBuildResult.SIZEOF == 4) {
			return getIntAtOffset(VM_JFRChunkWriter.__buildResultOffset_);
		} else if (JfrBuildResult.SIZEOF == 8) {
			return getLongAtOffset(VM_JFRChunkWriter.__buildResultOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// JfrBuildResult _buildResult
	public EnumPointer _buildResultEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__buildResultOffset_), JfrBuildResult.class);
	}

	// U8* _checkPointEventOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__checkPointEventOffsetOffset_", declaredType="U8*")
	public U8Pointer _checkPointEventOffset() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__checkPointEventOffsetOffset_));
	}

	// U8* _checkPointEventOffset
	public PointerPointer _checkPointEventOffsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__checkPointEventOffsetOffset_));
	}

	// VM_JFRConstantPoolTypes _constantPoolTypes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__constantPoolTypesOffset_", declaredType="VM_JFRConstantPoolTypes")
	public VM_JFRConstantPoolTypesPointer _constantPoolTypes() throws CorruptDataException {
		return VM_JFRConstantPoolTypesPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__constantPoolTypesOffset_));
	}

	// VM_JFRConstantPoolTypes _constantPoolTypes
	public PointerPointer _constantPoolTypesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__constantPoolTypesOffset_));
	}

	// U32 _currentFrameCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentFrameCountOffset_", declaredType="U32")
	public UDATA _currentFrameCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRChunkWriter.__currentFrameCountOffset_));
	}

	// U32 _currentFrameCount
	public UDATAPointer _currentFrameCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__currentFrameCountOffset_));
	}

	// StackFrame* _currentStackFrameBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentStackFrameBufferOffset_", declaredType="StackFrame*")
	public StackFramePointer _currentStackFrameBuffer() throws CorruptDataException {
		return StackFramePointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__currentStackFrameBufferOffset_));
	}

	// StackFrame* _currentStackFrameBuffer
	public PointerPointer _currentStackFrameBufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__currentStackFrameBufferOffset_));
	}

	// J9VMThread* _currentThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer _currentThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__currentThreadOffset_));
	}

	// J9VMThread* _currentThread
	public PointerPointer _currentThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__currentThreadOffset_));
	}

	// bool _debug
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__debugOffset_", declaredType="bool")
	public boolean _debug() throws CorruptDataException {
		return getBoolAtOffset(VM_JFRChunkWriter.__debugOffset_);
	}

	// bool _debug
	public BoolPointer _debugEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__debugOffset_));
	}

	// bool _finalWrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__finalWriteOffset_", declaredType="bool")
	public boolean _finalWrite() throws CorruptDataException {
		return getBoolAtOffset(VM_JFRChunkWriter.__finalWriteOffset_);
	}

	// bool _finalWrite
	public BoolPointer _finalWriteEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__finalWriteOffset_));
	}

	// StackTraceEntry* _firstStackTraceEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstStackTraceEntryOffset_", declaredType="StackTraceEntry*")
	public StackTraceEntryPointer _firstStackTraceEntry() throws CorruptDataException {
		return StackTraceEntryPointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__firstStackTraceEntryOffset_));
	}

	// StackTraceEntry* _firstStackTraceEntry
	public PointerPointer _firstStackTraceEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__firstStackTraceEntryOffset_));
	}

	// void** _globalStringTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__globalStringTableOffset_", declaredType="void**")
	public PointerPointer _globalStringTable() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__globalStringTableOffset_));
	}

	// void** _globalStringTable
	public PointerPointer _globalStringTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__globalStringTableOffset_));
	}

	// U8* _jfrHeaderCursor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__jfrHeaderCursorOffset_", declaredType="U8*")
	public U8Pointer _jfrHeaderCursor() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__jfrHeaderCursorOffset_));
	}

	// U8* _jfrHeaderCursor
	public PointerPointer _jfrHeaderCursorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__jfrHeaderCursorOffset_));
	}

	// U8* _lastDataStart
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__lastDataStartOffset_", declaredType="U8*")
	public U8Pointer _lastDataStart() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__lastDataStartOffset_));
	}

	// U8* _lastDataStart
	public PointerPointer _lastDataStartEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__lastDataStartOffset_));
	}

	// U8* _metadataOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__metadataOffsetOffset_", declaredType="U8*")
	public U8Pointer _metadataOffset() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__metadataOffsetOffset_));
	}

	// U8* _metadataOffset
	public PointerPointer _metadataOffsetEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__metadataOffsetOffset_));
	}

	// U8* _previousCheckpointDelta
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousCheckpointDeltaOffset_", declaredType="U8*")
	public U8Pointer _previousCheckpointDelta() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__previousCheckpointDeltaOffset_));
	}

	// U8* _previousCheckpointDelta
	public PointerPointer _previousCheckpointDeltaEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__previousCheckpointDeltaOffset_));
	}

	// StackTraceEntry* _previousStackTraceEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousStackTraceEntryOffset_", declaredType="StackTraceEntry*")
	public StackTraceEntryPointer _previousStackTraceEntry() throws CorruptDataException {
		return StackTraceEntryPointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__previousStackTraceEntryOffset_));
	}

	// StackTraceEntry* _previousStackTraceEntry
	public PointerPointer _previousStackTraceEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__previousStackTraceEntryOffset_));
	}

	// J9JavaVM* _vm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vmOffset_", declaredType="J9JavaVM*")
	public J9JavaVMPointer _vm() throws CorruptDataException {
		return J9JavaVMPointer.cast(getPointerAtOffset(VM_JFRChunkWriter.__vmOffset_));
	}

	// J9JavaVM* _vm
	public PointerPointer _vmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter.__vmOffset_));
	}

	// J9PortLibrary* privatePortLibrary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_privatePortLibraryOffset_", declaredType="J9PortLibrary*")
	public J9PortLibraryPointer privatePortLibrary() throws CorruptDataException {
		return J9PortLibraryPointer.cast(getPointerAtOffset(VM_JFRChunkWriter._privatePortLibraryOffset_));
	}

	// J9PortLibrary* privatePortLibrary
	public PointerPointer privatePortLibraryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRChunkWriter._privatePortLibraryOffset_));
	}

}
