/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: segment_command_64
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class segment_command_64 {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _cmdOffset_;
	public static final int _cmdsizeOffset_;
	public static final int _fileoffOffset_;
	public static final int _filesizeOffset_;
	public static final int _flagsOffset_;
	public static final int _initprotOffset_;
	public static final int _maxprotOffset_;
	public static final int _nsectsOffset_;
	public static final int _segnameOffset_;
	public static final int _vmaddrOffset_;
	public static final int _vmsizeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_cmdOffset_ = 0;
		_cmdsizeOffset_ = 0;
		_fileoffOffset_ = 0;
		_filesizeOffset_ = 0;
		_flagsOffset_ = 0;
		_initprotOffset_ = 0;
		_maxprotOffset_ = 0;
		_nsectsOffset_ = 0;
		_segnameOffset_ = 0;
		_vmaddrOffset_ = 0;
		_vmsizeOffset_ = 0;
	}

}
