/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: IbmjvmtiConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class IbmjvmtiConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long COM_IBM_DESTROYED_ALL_CACHE;
	public static final long COM_IBM_DESTROYED_NONE;
	public static final long COM_IBM_DESTROY_FAILED_CURRENT_GEN_CACHEE;
	public static final long COM_IBM_DESTROY_FAILED_OLDER_GEN_CACHE;
	public static final long COM_IBM_GET_MEMORY_CATEGORIES_VERSION_1;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_COMPRESSED_POINTERS_MODE;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_NON_COMPRESSED_POINTERS_MODE;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_NO_FLAGS;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_UNKNOWN_COMPRESSED_POINTERS_MODE;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_VERSION_1;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_VERSION_2;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_VERSION_3;
	public static final long COM_IBM_ITERATE_SHARED_CACHES_VERSION_4;
	public static final long COM_IBM_SHARED_CACHE_ADDRMODE_32;
	public static final long COM_IBM_SHARED_CACHE_ADDRMODE_64;
	public static final long COM_IBM_SHARED_CACHE_MODLEVEL_JAVA5;
	public static final long COM_IBM_SHARED_CACHE_MODLEVEL_JAVA6;
	public static final long COM_IBM_SHARED_CACHE_MODLEVEL_JAVA7;
	public static final long COM_IBM_SHARED_CACHE_MODLEVEL_JAVA8;
	public static final long COM_IBM_SHARED_CACHE_MODLEVEL_JAVA9;
	public static final long COM_IBM_SHARED_CACHE_NONPERSISTENT;
	public static final long COM_IBM_SHARED_CACHE_PERSISTENCE_DEFAULT;
	public static final long COM_IBM_SHARED_CACHE_PERSISTENT;
	public static final long COM_IBM_SHARED_CACHE_SNAPSHOT;
	public static final long JVMTI_MONITOR_JAVA;
	public static final long JVMTI_MONITOR_RAW;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		COM_IBM_DESTROYED_ALL_CACHE = 0;
		COM_IBM_DESTROYED_NONE = 0;
		COM_IBM_DESTROY_FAILED_CURRENT_GEN_CACHEE = 0;
		COM_IBM_DESTROY_FAILED_OLDER_GEN_CACHE = 0;
		COM_IBM_GET_MEMORY_CATEGORIES_VERSION_1 = 0;
		COM_IBM_ITERATE_SHARED_CACHES_COMPRESSED_POINTERS_MODE = 0;
		COM_IBM_ITERATE_SHARED_CACHES_NON_COMPRESSED_POINTERS_MODE = 0;
		COM_IBM_ITERATE_SHARED_CACHES_NO_FLAGS = 0;
		COM_IBM_ITERATE_SHARED_CACHES_UNKNOWN_COMPRESSED_POINTERS_MODE = 0;
		COM_IBM_ITERATE_SHARED_CACHES_VERSION_1 = 0;
		COM_IBM_ITERATE_SHARED_CACHES_VERSION_2 = 0;
		COM_IBM_ITERATE_SHARED_CACHES_VERSION_3 = 0;
		COM_IBM_ITERATE_SHARED_CACHES_VERSION_4 = 0;
		COM_IBM_SHARED_CACHE_ADDRMODE_32 = 0;
		COM_IBM_SHARED_CACHE_ADDRMODE_64 = 0;
		COM_IBM_SHARED_CACHE_MODLEVEL_JAVA5 = 0;
		COM_IBM_SHARED_CACHE_MODLEVEL_JAVA6 = 0;
		COM_IBM_SHARED_CACHE_MODLEVEL_JAVA7 = 0;
		COM_IBM_SHARED_CACHE_MODLEVEL_JAVA8 = 0;
		COM_IBM_SHARED_CACHE_MODLEVEL_JAVA9 = 0;
		COM_IBM_SHARED_CACHE_NONPERSISTENT = 0;
		COM_IBM_SHARED_CACHE_PERSISTENCE_DEFAULT = 0;
		COM_IBM_SHARED_CACHE_PERSISTENT = 0;
		COM_IBM_SHARED_CACHE_SNAPSHOT = 0;
		JVMTI_MONITOR_JAVA = 0;
		JVMTI_MONITOR_RAW = 0;
	}

}
