/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ScavengerStats
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ScavengerStats {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __acquireFreeListCountOffset_;
	public static final int __acquireListLockCountOffset_;
	public static final int __acquireScanListCountOffset_;
	public static final int __adjustedSyncStallTimeOffset_;
	public static final int __aliasToCopyCacheCountOffset_;
	public static final int __arraySplitAmountOffset_;
	public static final int __arraySplitCountOffset_;
	public static final int __avgExpectedFlipBytesOffset_;
	public static final int __avgInitialFreeOffset_;
	public static final int __avgTenureBytesOffset_;
	public static final int __avgTenureBytesDeviationOffset_;
	public static final int __avgTenureLOABytesOffset_;
	public static final int __backoutOffset_;
	public static final int __causedRememberedSetOverflowOffset_;
	public static final int __completeStallCountOffset_;
	public static final int __completeStallTimeOffset_;
	public static final int __copyScanUpdatesOffset_;
	public static final int __copy_cachesize_countsOffset_;
	public static final int __copy_cachesize_sumOffset_;
	public static final int __copy_distance_countsOffset_;
	public static final int __depthDeepestStructureOffset_;
	public static final int __endTimeOffset_;
	public static final int __failedFlipBytesOffset_;
	public static final int __failedFlipCountOffset_;
	public static final int __failedTenureBytesOffset_;
	public static final int __failedTenureCountOffset_;
	public static final int __failedTenureLargestOffset_;
	public static final int __flipBytesOffset_;
	public static final int __flipCountOffset_;
	public static final int __flipDiscardBytesOffset_;
	public static final int __flipHistoryOffset_;
	public static final int __flipHistoryNewIndexOffset_;
	public static final int __gcCountOffset_;
	public static final int __leafObjectCountOffset_;
	public static final int __nextScavengeWillPercolateOffset_;
	public static final int __notifyStallTimeOffset_;
	public static final int __readObjectBarrierCopyOffset_;
	public static final int __readObjectBarrierFlipBytesOffset_;
	public static final int __readObjectBarrierTenureBytesOffset_;
	public static final int __readObjectBarrierUpdateOffset_;
	public static final int __releaseFreeListCountOffset_;
	public static final int __releaseScanListCountOffset_;
	public static final int __rememberedSetOverflowOffset_;
	public static final int __scanCacheAllocationDurationDuringSavengerOffset_;
	public static final int __scanCacheAllocationFromHeapOffset_;
	public static final int __scanCacheOverflowOffset_;
	public static final int __semiSpaceAllocBytesAcumulationOffset_;
	public static final int __semiSpaceAllocationCountLargeOffset_;
	public static final int __semiSpaceAllocationCountSmallOffset_;
	public static final int __slotsCopiedOffset_;
	public static final int __slotsScannedOffset_;
	public static final int __startTimeOffset_;
	public static final int __survivorTLHRemainderCountOffset_;
	public static final int __syncStallCountOffset_;
	public static final int __syncStallTimeOffset_;
	public static final int __tenureAgeOffset_;
	public static final int __tenureAggregateBytesOffset_;
	public static final int __tenureAggregateCountOffset_;
	public static final int __tenureDiscardBytesOffset_;
	public static final int __tenureExpandedBytesOffset_;
	public static final int __tenureExpandedCountOffset_;
	public static final int __tenureExpandedTimeOffset_;
	public static final int __tenureLOABytesOffset_;
	public static final int __tenureLOACountOffset_;
	public static final int __tenureSpaceAllocBytesAcumulationOffset_;
	public static final int __tenureSpaceAllocationCountLargeOffset_;
	public static final int __tenureSpaceAllocationCountSmallOffset_;
	public static final int __tenureTLHRemainderCountOffset_;
	public static final int __tiltRatioOffset_;
	public static final int __totalDeepStructuresOffset_;
	public static final int __totalObjsDeepScannedOffset_;
	public static final int __workStallCountOffset_;
	public static final int __workStallTimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__acquireFreeListCountOffset_ = 0;
		__acquireListLockCountOffset_ = 0;
		__acquireScanListCountOffset_ = 0;
		__adjustedSyncStallTimeOffset_ = 0;
		__aliasToCopyCacheCountOffset_ = 0;
		__arraySplitAmountOffset_ = 0;
		__arraySplitCountOffset_ = 0;
		__avgExpectedFlipBytesOffset_ = 0;
		__avgInitialFreeOffset_ = 0;
		__avgTenureBytesOffset_ = 0;
		__avgTenureBytesDeviationOffset_ = 0;
		__avgTenureLOABytesOffset_ = 0;
		__backoutOffset_ = 0;
		__causedRememberedSetOverflowOffset_ = 0;
		__completeStallCountOffset_ = 0;
		__completeStallTimeOffset_ = 0;
		__copyScanUpdatesOffset_ = 0;
		__copy_cachesize_countsOffset_ = 0;
		__copy_cachesize_sumOffset_ = 0;
		__copy_distance_countsOffset_ = 0;
		__depthDeepestStructureOffset_ = 0;
		__endTimeOffset_ = 0;
		__failedFlipBytesOffset_ = 0;
		__failedFlipCountOffset_ = 0;
		__failedTenureBytesOffset_ = 0;
		__failedTenureCountOffset_ = 0;
		__failedTenureLargestOffset_ = 0;
		__flipBytesOffset_ = 0;
		__flipCountOffset_ = 0;
		__flipDiscardBytesOffset_ = 0;
		__flipHistoryOffset_ = 0;
		__flipHistoryNewIndexOffset_ = 0;
		__gcCountOffset_ = 0;
		__leafObjectCountOffset_ = 0;
		__nextScavengeWillPercolateOffset_ = 0;
		__notifyStallTimeOffset_ = 0;
		__readObjectBarrierCopyOffset_ = 0;
		__readObjectBarrierFlipBytesOffset_ = 0;
		__readObjectBarrierTenureBytesOffset_ = 0;
		__readObjectBarrierUpdateOffset_ = 0;
		__releaseFreeListCountOffset_ = 0;
		__releaseScanListCountOffset_ = 0;
		__rememberedSetOverflowOffset_ = 0;
		__scanCacheAllocationDurationDuringSavengerOffset_ = 0;
		__scanCacheAllocationFromHeapOffset_ = 0;
		__scanCacheOverflowOffset_ = 0;
		__semiSpaceAllocBytesAcumulationOffset_ = 0;
		__semiSpaceAllocationCountLargeOffset_ = 0;
		__semiSpaceAllocationCountSmallOffset_ = 0;
		__slotsCopiedOffset_ = 0;
		__slotsScannedOffset_ = 0;
		__startTimeOffset_ = 0;
		__survivorTLHRemainderCountOffset_ = 0;
		__syncStallCountOffset_ = 0;
		__syncStallTimeOffset_ = 0;
		__tenureAgeOffset_ = 0;
		__tenureAggregateBytesOffset_ = 0;
		__tenureAggregateCountOffset_ = 0;
		__tenureDiscardBytesOffset_ = 0;
		__tenureExpandedBytesOffset_ = 0;
		__tenureExpandedCountOffset_ = 0;
		__tenureExpandedTimeOffset_ = 0;
		__tenureLOABytesOffset_ = 0;
		__tenureLOACountOffset_ = 0;
		__tenureSpaceAllocBytesAcumulationOffset_ = 0;
		__tenureSpaceAllocationCountLargeOffset_ = 0;
		__tenureSpaceAllocationCountSmallOffset_ = 0;
		__tenureTLHRemainderCountOffset_ = 0;
		__tiltRatioOffset_ = 0;
		__totalDeepStructuresOffset_ = 0;
		__totalObjsDeepScannedOffset_ = 0;
		__workStallCountOffset_ = 0;
		__workStallTimeOffset_ = 0;
	}

}
