/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.test.lib.Platform;

public class NetworkConfiguration {
    private Map<NetworkInterface, List<Inet4Address>> ip4Interfaces;
    private Map<NetworkInterface, List<Inet6Address>> ip6Interfaces;
    private final boolean isIPv6Available;
    private boolean has_testableipv6address = false;
    private boolean has_sitelocaladdress = false;
    private boolean has_linklocaladdress = false;
    private boolean has_globaladdress = false;

    private NetworkConfiguration(Map<NetworkInterface, List<Inet4Address>> ip4Interfaces, Map<NetworkInterface, List<Inet6Address>> ip6Interfaces) {
        this.ip4Interfaces = ip4Interfaces;
        this.ip6Interfaces = ip6Interfaces;
        this.isIPv6Available = !this.ip6Interfaces().collect(Collectors.toList()).isEmpty();
        this.ip6Interfaces().forEach(nif -> this.ip6Addresses((NetworkInterface)nif).filter(addr -> Platform.isAix() ? !addr.isAnyLocalAddress() && !addr.isLoopbackAddress() : true).forEach(ia -> {
            this.has_testableipv6address = true;
            if (ia.isLinkLocalAddress()) {
                this.has_linklocaladdress = true;
            }
            if (ia.isSiteLocalAddress()) {
                this.has_sitelocaladdress = true;
            }
            if (!(ia.isLinkLocalAddress() || ia.isSiteLocalAddress() || ia.isLoopbackAddress())) {
                this.has_globaladdress = true;
            }
        }));
    }

    private static boolean isIPv6LinkLocal(InetAddress a) {
        return Inet6Address.class.isInstance(a) && a.isLinkLocalAddress();
    }

    public static boolean isSameInterface(NetworkInterface ni1, NetworkInterface ni2) {
        if (Objects.equals(ni1, ni2)) {
            return true;
        }
        if (ni1 == null || ni2 == null) {
            return false;
        }
        if (ni1.getIndex() != ni2.getIndex()) {
            return false;
        }
        return Objects.equals(ni1.getName(), ni2.getName());
    }

    public static boolean isTestable(NetworkInterface nif) {
        String dName;
        if (Platform.isOSX()) {
            if (nif.getName().contains("awdl") || nif.getName().contains("docker")) {
                return false;
            }
            return nif.inetAddresses().filter(Predicate.not(NetworkConfiguration::isIPv6LinkLocal)).findAny().isPresent();
        }
        if (Platform.isWindows() && (dName = nif.getDisplayName()) != null && dName.contains("Teredo")) {
            return false;
        }
        return !Platform.isLinux() || (dName = nif.getDisplayName()) == null || !dName.contains("docker");
    }

    private static boolean isNotLoopback(NetworkInterface nif) {
        try {
            return !nif.isLoopback();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean hasIp4Addresses(NetworkInterface nif) {
        return this.ip4Interfaces.get(nif).stream().anyMatch(a -> !a.isAnyLocalAddress());
    }

    private boolean hasIp6Addresses(NetworkInterface nif) {
        return this.ip6Interfaces.get(nif).stream().anyMatch(a -> !a.isAnyLocalAddress());
    }

    public static boolean hasNonLinkLocalAddress(NetworkInterface nif) {
        return nif.inetAddresses().filter(Predicate.not(InetAddress::isLinkLocalAddress)).findAny().isPresent();
    }

    private boolean supportsIp4Multicast(NetworkInterface nif) {
        try {
            if (!nif.supportsMulticast()) {
                return false;
            }
            if (Platform.isOSX() && !NetworkConfiguration.hasNonLinkLocalAddress(nif)) {
                return false;
            }
            return this.hasIp4Addresses(nif);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean supportsIp6Multicast(NetworkInterface nif) {
        try {
            if (!nif.supportsMulticast()) {
                return false;
            }
            if (Platform.isOSX() && !NetworkConfiguration.hasNonLinkLocalAddress(nif)) {
                return false;
            }
            return this.hasIp6Addresses(nif);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isIPv6Available() {
        return this.isIPv6Available;
    }

    public boolean hasTestableIPv6Address() {
        return this.has_testableipv6address;
    }

    public boolean hasSiteLocalAddress() {
        return this.has_sitelocaladdress;
    }

    public boolean hasLinkLocalAddress() {
        return this.has_linklocaladdress;
    }

    public boolean has_globaladdress() {
        return this.has_globaladdress;
    }

    public Stream<NetworkInterface> interfaces() {
        return Stream.concat(this.ip4Interfaces(), this.ip6Interfaces()).distinct();
    }

    public Stream<NetworkInterface> ip4Interfaces() {
        return this.ip4Interfaces.keySet().stream().filter(NetworkConfiguration::isTestable).filter(this::hasIp4Addresses);
    }

    public Stream<NetworkInterface> ip6Interfaces() {
        return this.ip6Interfaces.keySet().stream().filter(NetworkConfiguration::isTestable).filter(this::hasIp6Addresses);
    }

    public Stream<NetworkInterface> multicastInterfaces(boolean includeLoopback) {
        return Stream.concat(this.ip4MulticastInterfaces(includeLoopback), this.ip6MulticastInterfaces(includeLoopback)).distinct();
    }

    public Stream<NetworkInterface> ip4MulticastInterfaces() {
        return this.ip4MulticastInterfaces(false);
    }

    public Stream<NetworkInterface> ip4MulticastInterfaces(boolean includeLoopback) {
        return includeLoopback ? this.ip4Interfaces().filter(this::supportsIp4Multicast) : this.ip4Interfaces().filter(this::supportsIp4Multicast).filter(NetworkConfiguration::isNotLoopback);
    }

    public Stream<NetworkInterface> ip6MulticastInterfaces() {
        return this.ip6MulticastInterfaces(false);
    }

    public Stream<NetworkInterface> ip6MulticastInterfaces(boolean includeLoopback) {
        return includeLoopback ? this.ip6Interfaces().filter(this::supportsIp6Multicast) : this.ip6Interfaces().filter(this::supportsIp6Multicast).filter(NetworkConfiguration::isNotLoopback);
    }

    public Stream<InetAddress> addresses(NetworkInterface nif) {
        return Stream.concat(this.ip4Interfaces.get(nif).stream(), this.ip6Interfaces.get(nif).stream());
    }

    public Stream<Inet4Address> ip4Addresses() {
        return this.ip4Interfaces().flatMap(this::ip4Addresses);
    }

    public Stream<Inet6Address> ip6Addresses() {
        return this.ip6Interfaces().flatMap(this::ip6Addresses);
    }

    public Stream<Inet4Address> ip4Addresses(NetworkInterface nif) {
        return this.ip4Interfaces.get(nif).stream();
    }

    public Stream<Inet6Address> ip6Addresses(NetworkInterface nif) {
        return this.ip6Interfaces.get(nif).stream();
    }

    public String toString() {
        return this.interfaces().map(NetworkConfiguration::interfaceInformation).collect(Collectors.joining());
    }

    public static NetworkConfiguration probe() throws IOException {
        LinkedHashMap<NetworkInterface, List<Inet4Address>> ip4Interfaces = new LinkedHashMap<NetworkInterface, List<Inet4Address>>();
        LinkedHashMap<NetworkInterface, List<Inet6Address>> ip6Interfaces = new LinkedHashMap<NetworkInterface, List<Inet6Address>>();
        ArrayList<NetworkInterface> nifs = Collections.list(NetworkInterface.getNetworkInterfaces());
        for (NetworkInterface nif : nifs) {
            if (!nif.isUp() || nif.isPointToPoint()) continue;
            LinkedList<Inet4Address> ip4Addresses = new LinkedList<Inet4Address>();
            LinkedList<Inet6Address> ip6Addresses = new LinkedList<Inet6Address>();
            ip4Interfaces.put(nif, ip4Addresses);
            ip6Interfaces.put(nif, ip6Addresses);
            for (InetAddress addr : Collections.list(nif.getInetAddresses())) {
                if (addr instanceof Inet4Address) {
                    ip4Addresses.add((Inet4Address)addr);
                    continue;
                }
                if (!(addr instanceof Inet6Address)) continue;
                ip6Addresses.add((Inet6Address)addr);
            }
        }
        return new NetworkConfiguration(ip4Interfaces, ip6Interfaces);
    }

    public static String interfaceInformation(NetworkInterface nif) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("Display name: ").append(nif.getDisplayName()).append("\n");
            sb.append("Name: ").append(nif.getName()).append("\n");
            for (InetAddress inetAddress : Collections.list(nif.getInetAddresses())) {
                sb.append("InetAddress: ").append(inetAddress).append("\n");
            }
            sb.append("Up? ").append(nif.isUp()).append("\n");
            sb.append("Loopback? ").append(nif.isLoopback()).append("\n");
            sb.append("PointToPoint? ").append(nif.isPointToPoint()).append("\n");
            sb.append("Supports multicast? ").append(nif.supportsMulticast()).append("\n");
            sb.append("Virtual? ").append(nif.isVirtual()).append("\n");
            sb.append("Hardware address: ").append(Arrays.toString(nif.getHardwareAddress())).append("\n");
            sb.append("MTU: ").append(nif.getMTU()).append("\n");
            sb.append("Index: ").append(nif.getIndex()).append("\n");
            sb.append("\n");
            return sb.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void printSystemConfiguration(PrintStream out) {
        try {
            out.println("*** all system network interface configuration ***");
            for (NetworkInterface nif : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                out.print(NetworkConfiguration.interfaceInformation(nif));
            }
            out.println("*** end ***");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

