/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __ucontext64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __ucontext64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__ucontext64.class)
public class __ucontext64Pointer extends StructurePointer {

	// NULL
	public static final __ucontext64Pointer NULL = new __ucontext64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __ucontext64Pointer(long address) {
		super(address);
	}

	public static __ucontext64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __ucontext64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __ucontext64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __ucontext64Pointer(address);
	}

	public __ucontext64Pointer add(long count) {
		return __ucontext64Pointer.cast(address + (__ucontext64.SIZEOF * count));
	}

	public __ucontext64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public __ucontext64Pointer addOffset(long offset) {
		return __ucontext64Pointer.cast(address + offset);
	}

	public __ucontext64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __ucontext64Pointer sub(long count) {
		return __ucontext64Pointer.cast(address - (__ucontext64.SIZEOF * count));
	}

	public __ucontext64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __ucontext64Pointer subOffset(long offset) {
		return __ucontext64Pointer.cast(address - offset);
	}

	public __ucontext64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __ucontext64Pointer untag(long mask) {
		return __ucontext64Pointer.cast(address & ~mask);
	}

	public __ucontext64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __ucontext64.SIZEOF;
	}

	// Implementation methods

	// U64 __extctx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctxOffset_", declaredType="U64")
	public UDATA __extctx() throws CorruptDataException {
		return new U64(getLongAtOffset(__ucontext64.___extctxOffset_));
	}

	// U64 __extctx
	public UDATAPointer __extctxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__ucontext64.___extctxOffset_));
	}

	// I32 __extctx_magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctx_magicOffset_", declaredType="I32")
	public IDATA __extctx_magic() throws CorruptDataException {
		return new I32(getIntAtOffset(__ucontext64.___extctx_magicOffset_));
	}

	// I32 __extctx_magic
	public IDATAPointer __extctx_magicEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__ucontext64.___extctx_magicOffset_));
	}

	// I32[] __pad
	public IDATAPointer __padEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(__ucontext64.___padOffset_));
	}

	// I32 __sc_onstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sc_onstackOffset_", declaredType="I32")
	public IDATA __sc_onstack() throws CorruptDataException {
		return new I32(getIntAtOffset(__ucontext64.___sc_onstackOffset_));
	}

	// I32 __sc_onstack
	public IDATAPointer __sc_onstackEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__ucontext64.___sc_onstackOffset_));
	}

	// I32 __sc_uerror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sc_uerrorOffset_", declaredType="I32")
	public IDATA __sc_uerror() throws CorruptDataException {
		return new I32(getIntAtOffset(__ucontext64.___sc_uerrorOffset_));
	}

	// I32 __sc_uerror
	public IDATAPointer __sc_uerrorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__ucontext64.___sc_uerrorOffset_));
	}

	// U64 uc_link64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_link64Offset_", declaredType="U64")
	public UDATA uc_link64() throws CorruptDataException {
		return new U64(getLongAtOffset(__ucontext64._uc_link64Offset_));
	}

	// U64 uc_link64
	public UDATAPointer uc_link64EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__ucontext64._uc_link64Offset_));
	}

	// mcontext64_t uc_mcontext64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_mcontext64Offset_", declaredType="mcontext64_t")
	public __context64Pointer uc_mcontext64() throws CorruptDataException {
		return __context64Pointer.cast(nonNullFieldEA(__ucontext64._uc_mcontext64Offset_));
	}

	// mcontext64_t uc_mcontext64
	public PointerPointer uc_mcontext64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__ucontext64._uc_mcontext64Offset_));
	}

	// sigset64_t uc_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_sigmaskOffset_", declaredType="sigset64_t")
	public sigset64_tPointer uc_sigmask() throws CorruptDataException {
		return sigset64_tPointer.cast(nonNullFieldEA(__ucontext64._uc_sigmaskOffset_));
	}

	// sigset64_t uc_sigmask
	public PointerPointer uc_sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__ucontext64._uc_sigmaskOffset_));
	}

	// stack64_t uc_stack64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_stack64Offset_", declaredType="stack64_t")
	public stack64_tPointer uc_stack64() throws CorruptDataException {
		return stack64_tPointer.cast(nonNullFieldEA(__ucontext64._uc_stack64Offset_));
	}

	// stack64_t uc_stack64
	public PointerPointer uc_stack64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__ucontext64._uc_stack64Offset_));
	}

}
