/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: numeric_tablePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the numeric_tablePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=numeric_table.class)
public class numeric_tablePointer extends StructurePointer {

	// NULL
	public static final numeric_tablePointer NULL = new numeric_tablePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected numeric_tablePointer(long address) {
		super(address);
	}

	public static numeric_tablePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static numeric_tablePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static numeric_tablePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new numeric_tablePointer(address);
	}

	public numeric_tablePointer add(long count) {
		return numeric_tablePointer.cast(address + (numeric_table.SIZEOF * count));
	}

	public numeric_tablePointer add(Scalar count) {
		return add(count.longValue());
	}

	public numeric_tablePointer addOffset(long offset) {
		return numeric_tablePointer.cast(address + offset);
	}

	public numeric_tablePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public numeric_tablePointer sub(long count) {
		return numeric_tablePointer.cast(address - (numeric_table.SIZEOF * count));
	}

	public numeric_tablePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public numeric_tablePointer subOffset(long offset) {
		return numeric_tablePointer.cast(address - offset);
	}

	public numeric_tablePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public numeric_tablePointer untag(long mask) {
		return numeric_tablePointer.cast(address & ~mask);
	}

	public numeric_tablePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return numeric_table.SIZEOF;
	}

	// Implementation methods

	// U8* decimal_point
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decimal_pointOffset_", declaredType="U8*")
	public U8Pointer decimal_point() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(numeric_table._decimal_pointOffset_));
	}

	// U8* decimal_point
	public PointerPointer decimal_pointEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(numeric_table._decimal_pointOffset_));
	}

	// U8* grouping
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_groupingOffset_", declaredType="U8*")
	public U8Pointer grouping() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(numeric_table._groupingOffset_));
	}

	// U8* grouping
	public PointerPointer groupingEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(numeric_table._groupingOffset_));
	}

	// I16 lc_length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_lengthOffset_", declaredType="I16")
	public I16 lc_length() throws CorruptDataException {
		return new I16(getShortAtOffset(numeric_table._lc_lengthOffset_));
	}

	// I16 lc_length
	public I16Pointer lc_lengthEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(numeric_table._lc_lengthOffset_));
	}

	// U8* lc_locale_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_locale_nameOffset_", declaredType="U8*")
	public U8Pointer lc_locale_name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(numeric_table._lc_locale_nameOffset_));
	}

	// U8* lc_locale_name
	public PointerPointer lc_locale_nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(numeric_table._lc_locale_nameOffset_));
	}

	// I16 lc_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lc_versionOffset_", declaredType="I16")
	public I16 lc_version() throws CorruptDataException {
		return new I16(getShortAtOffset(numeric_table._lc_versionOffset_));
	}

	// I16 lc_version
	public I16Pointer lc_versionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(numeric_table._lc_versionOffset_));
	}

	// U8* thousands_sep
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thousands_sepOffset_", declaredType="U8*")
	public U8Pointer thousands_sep() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(numeric_table._thousands_sepOffset_));
	}

	// U8* thousands_sep
	public PointerPointer thousands_sepEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(numeric_table._thousands_sepOffset_));
	}

}
