/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: perfstat_cpu_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the perfstat_cpu_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=perfstat_cpu_t.class)
public class perfstat_cpu_tPointer extends StructurePointer {

	// NULL
	public static final perfstat_cpu_tPointer NULL = new perfstat_cpu_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected perfstat_cpu_tPointer(long address) {
		super(address);
	}

	public static perfstat_cpu_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static perfstat_cpu_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static perfstat_cpu_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new perfstat_cpu_tPointer(address);
	}

	public perfstat_cpu_tPointer add(long count) {
		return perfstat_cpu_tPointer.cast(address + (perfstat_cpu_t.SIZEOF * count));
	}

	public perfstat_cpu_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public perfstat_cpu_tPointer addOffset(long offset) {
		return perfstat_cpu_tPointer.cast(address + offset);
	}

	public perfstat_cpu_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public perfstat_cpu_tPointer sub(long count) {
		return perfstat_cpu_tPointer.cast(address - (perfstat_cpu_t.SIZEOF * count));
	}

	public perfstat_cpu_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public perfstat_cpu_tPointer subOffset(long offset) {
		return perfstat_cpu_tPointer.cast(address - offset);
	}

	public perfstat_cpu_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public perfstat_cpu_tPointer untag(long mask) {
		return perfstat_cpu_tPointer.cast(address & ~mask);
	}

	public perfstat_cpu_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return perfstat_cpu_t.SIZEOF;
	}

	// Implementation methods

	// u_longlong_t bound
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_boundOffset_", declaredType="u_longlong_t")
	public UDATA bound() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._boundOffset_));
	}

	// u_longlong_t bound
	public UDATAPointer boundEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._boundOffset_));
	}

	// u_longlong_t bread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_breadOffset_", declaredType="u_longlong_t")
	public UDATA bread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._breadOffset_));
	}

	// u_longlong_t bread
	public UDATAPointer breadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._breadOffset_));
	}

	// u_longlong_t busy_donated_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_donated_purrOffset_", declaredType="u_longlong_t")
	public UDATA busy_donated_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._busy_donated_purrOffset_));
	}

	// u_longlong_t busy_donated_purr
	public UDATAPointer busy_donated_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._busy_donated_purrOffset_));
	}

	// u_longlong_t busy_donated_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_donated_spurrOffset_", declaredType="u_longlong_t")
	public UDATA busy_donated_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._busy_donated_spurrOffset_));
	}

	// u_longlong_t busy_donated_spurr
	public UDATAPointer busy_donated_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._busy_donated_spurrOffset_));
	}

	// u_longlong_t busy_stolen_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_stolen_purrOffset_", declaredType="u_longlong_t")
	public UDATA busy_stolen_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._busy_stolen_purrOffset_));
	}

	// u_longlong_t busy_stolen_purr
	public UDATAPointer busy_stolen_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._busy_stolen_purrOffset_));
	}

	// u_longlong_t busy_stolen_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_busy_stolen_spurrOffset_", declaredType="u_longlong_t")
	public UDATA busy_stolen_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._busy_stolen_spurrOffset_));
	}

	// u_longlong_t busy_stolen_spurr
	public UDATAPointer busy_stolen_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._busy_stolen_spurrOffset_));
	}

	// u_longlong_t bwrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bwriteOffset_", declaredType="u_longlong_t")
	public UDATA bwrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._bwriteOffset_));
	}

	// u_longlong_t bwrite
	public UDATAPointer bwriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._bwriteOffset_));
	}

	// u_longlong_t cswitches
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cswitchesOffset_", declaredType="u_longlong_t")
	public UDATA cswitches() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._cswitchesOffset_));
	}

	// u_longlong_t cswitches
	public UDATAPointer cswitchesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._cswitchesOffset_));
	}

	// u_longlong_t decrintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_decrintrsOffset_", declaredType="u_longlong_t")
	public UDATA decrintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._decrintrsOffset_));
	}

	// u_longlong_t decrintrs
	public UDATAPointer decrintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._decrintrsOffset_));
	}

	// u_longlong_t devintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_devintrsOffset_", declaredType="u_longlong_t")
	public UDATA devintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._devintrsOffset_));
	}

	// u_longlong_t devintrs
	public UDATAPointer devintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._devintrsOffset_));
	}

	// u_longlong_t dirblk
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dirblkOffset_", declaredType="u_longlong_t")
	public UDATA dirblk() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._dirblkOffset_));
	}

	// u_longlong_t dirblk
	public UDATAPointer dirblkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._dirblkOffset_));
	}

	// u_longlong_t fardispatch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fardispatchOffset_", declaredType="u_longlong_t")
	public UDATA fardispatch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._fardispatchOffset_));
	}

	// u_longlong_t fardispatch
	public UDATAPointer fardispatchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._fardispatchOffset_));
	}

	// u_longlong_t hpi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hpiOffset_", declaredType="u_longlong_t")
	public UDATA hpi() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._hpiOffset_));
	}

	// u_longlong_t hpi
	public UDATAPointer hpiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._hpiOffset_));
	}

	// u_longlong_t hpit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hpitOffset_", declaredType="u_longlong_t")
	public UDATA hpit() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._hpitOffset_));
	}

	// u_longlong_t hpit
	public UDATAPointer hpitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._hpitOffset_));
	}

	// u_longlong_t icount_last
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_icount_lastOffset_", declaredType="u_longlong_t")
	public UDATA icount_last() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._icount_lastOffset_));
	}

	// u_longlong_t icount_last
	public UDATAPointer icount_lastEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._icount_lastOffset_));
	}

	// u_longlong_t idle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idleOffset_", declaredType="u_longlong_t")
	public UDATA idle() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._idleOffset_));
	}

	// u_longlong_t idle
	public UDATAPointer idleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._idleOffset_));
	}

	// u_longlong_t idle_donated_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_donated_purrOffset_", declaredType="u_longlong_t")
	public UDATA idle_donated_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._idle_donated_purrOffset_));
	}

	// u_longlong_t idle_donated_purr
	public UDATAPointer idle_donated_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._idle_donated_purrOffset_));
	}

	// u_longlong_t idle_donated_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_donated_spurrOffset_", declaredType="u_longlong_t")
	public UDATA idle_donated_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._idle_donated_spurrOffset_));
	}

	// u_longlong_t idle_donated_spurr
	public UDATAPointer idle_donated_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._idle_donated_spurrOffset_));
	}

	// u_longlong_t idle_stolen_purr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_stolen_purrOffset_", declaredType="u_longlong_t")
	public UDATA idle_stolen_purr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._idle_stolen_purrOffset_));
	}

	// u_longlong_t idle_stolen_purr
	public UDATAPointer idle_stolen_purrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._idle_stolen_purrOffset_));
	}

	// u_longlong_t idle_stolen_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idle_stolen_spurrOffset_", declaredType="u_longlong_t")
	public UDATA idle_stolen_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._idle_stolen_spurrOffset_));
	}

	// u_longlong_t idle_stolen_spurr
	public UDATAPointer idle_stolen_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._idle_stolen_spurrOffset_));
	}

	// u_longlong_t iget
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_igetOffset_", declaredType="u_longlong_t")
	public UDATA iget() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._igetOffset_));
	}

	// u_longlong_t iget
	public UDATAPointer igetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._igetOffset_));
	}

	// u_longlong_t invol_cswitch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_invol_cswitchOffset_", declaredType="u_longlong_t")
	public UDATA invol_cswitch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._invol_cswitchOffset_));
	}

	// u_longlong_t invol_cswitch
	public UDATAPointer invol_cswitchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._invol_cswitchOffset_));
	}

	// u_longlong_t localdispatch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_localdispatchOffset_", declaredType="u_longlong_t")
	public UDATA localdispatch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._localdispatchOffset_));
	}

	// u_longlong_t localdispatch
	public UDATAPointer localdispatchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._localdispatchOffset_));
	}

	// u_longlong_t lread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lreadOffset_", declaredType="u_longlong_t")
	public UDATA lread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._lreadOffset_));
	}

	// u_longlong_t lread
	public UDATAPointer lreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._lreadOffset_));
	}

	// u_longlong_t lwrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lwriteOffset_", declaredType="u_longlong_t")
	public UDATA lwrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._lwriteOffset_));
	}

	// u_longlong_t lwrite
	public UDATAPointer lwriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._lwriteOffset_));
	}

	// u_longlong_t majfaults
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_majfaultsOffset_", declaredType="u_longlong_t")
	public UDATA majfaults() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._majfaultsOffset_));
	}

	// u_longlong_t majfaults
	public UDATAPointer majfaultsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._majfaultsOffset_));
	}

	// u_longlong_t migration_S3grq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_migration_S3grqOffset_", declaredType="u_longlong_t")
	public UDATA migration_S3grq() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._migration_S3grqOffset_));
	}

	// u_longlong_t migration_S3grq
	public UDATAPointer migration_S3grqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._migration_S3grqOffset_));
	}

	// u_longlong_t migration_S3pul
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_migration_S3pulOffset_", declaredType="u_longlong_t")
	public UDATA migration_S3pul() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._migration_S3pulOffset_));
	}

	// u_longlong_t migration_S3pul
	public UDATAPointer migration_S3pulEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._migration_S3pulOffset_));
	}

	// u_longlong_t migration_push
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_migration_pushOffset_", declaredType="u_longlong_t")
	public UDATA migration_push() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._migration_pushOffset_));
	}

	// u_longlong_t migration_push
	public UDATAPointer migration_pushEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._migration_pushOffset_));
	}

	// u_longlong_t minfaults
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minfaultsOffset_", declaredType="u_longlong_t")
	public UDATA minfaults() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._minfaultsOffset_));
	}

	// u_longlong_t minfaults
	public UDATAPointer minfaultsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._minfaultsOffset_));
	}

	// u_longlong_t mpcrintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mpcrintrsOffset_", declaredType="u_longlong_t")
	public UDATA mpcrintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._mpcrintrsOffset_));
	}

	// u_longlong_t mpcrintrs
	public UDATAPointer mpcrintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._mpcrintrsOffset_));
	}

	// u_longlong_t mpcsintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mpcsintrsOffset_", declaredType="u_longlong_t")
	public UDATA mpcsintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._mpcsintrsOffset_));
	}

	// u_longlong_t mpcsintrs
	public UDATAPointer mpcsintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._mpcsintrsOffset_));
	}

	// u_longlong_t msg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_msgOffset_", declaredType="u_longlong_t")
	public UDATA msg() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._msgOffset_));
	}

	// u_longlong_t msg
	public UDATAPointer msgEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._msgOffset_));
	}

	// U8[] name
	public U8Pointer nameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(perfstat_cpu_t._nameOffset_));
	}

	// u_longlong_t namei
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameiOffset_", declaredType="u_longlong_t")
	public UDATA namei() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._nameiOffset_));
	}

	// u_longlong_t namei
	public UDATAPointer nameiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._nameiOffset_));
	}

	// u_longlong_t neardispatch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_neardispatchOffset_", declaredType="u_longlong_t")
	public UDATA neardispatch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._neardispatchOffset_));
	}

	// u_longlong_t neardispatch
	public UDATAPointer neardispatchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._neardispatchOffset_));
	}

	// u_longlong_t phantintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phantintrsOffset_", declaredType="u_longlong_t")
	public UDATA phantintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._phantintrsOffset_));
	}

	// u_longlong_t phantintrs
	public UDATAPointer phantintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._phantintrsOffset_));
	}

	// u_longlong_t phread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phreadOffset_", declaredType="u_longlong_t")
	public UDATA phread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._phreadOffset_));
	}

	// u_longlong_t phread
	public UDATAPointer phreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._phreadOffset_));
	}

	// u_longlong_t phwrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_phwriteOffset_", declaredType="u_longlong_t")
	public UDATA phwrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._phwriteOffset_));
	}

	// u_longlong_t phwrite
	public UDATAPointer phwriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._phwriteOffset_));
	}

	// u_longlong_t pidle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidleOffset_", declaredType="u_longlong_t")
	public UDATA pidle() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._pidleOffset_));
	}

	// u_longlong_t pidle
	public UDATAPointer pidleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._pidleOffset_));
	}

	// u_longlong_t pidle_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidle_spurrOffset_", declaredType="u_longlong_t")
	public UDATA pidle_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._pidle_spurrOffset_));
	}

	// u_longlong_t pidle_spurr
	public UDATAPointer pidle_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._pidle_spurrOffset_));
	}

	// u_longlong_t pswitch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pswitchOffset_", declaredType="u_longlong_t")
	public UDATA pswitch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._pswitchOffset_));
	}

	// u_longlong_t pswitch
	public UDATAPointer pswitchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._pswitchOffset_));
	}

	// u_longlong_t psys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psysOffset_", declaredType="u_longlong_t")
	public UDATA psys() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._psysOffset_));
	}

	// u_longlong_t psys
	public UDATAPointer psysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._psysOffset_));
	}

	// u_longlong_t psys_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psys_spurrOffset_", declaredType="u_longlong_t")
	public UDATA psys_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._psys_spurrOffset_));
	}

	// u_longlong_t psys_spurr
	public UDATAPointer psys_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._psys_spurrOffset_));
	}

	// u_longlong_t puser
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puserOffset_", declaredType="u_longlong_t")
	public UDATA puser() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._puserOffset_));
	}

	// u_longlong_t puser
	public UDATAPointer puserEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._puserOffset_));
	}

	// u_longlong_t puser_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_puser_spurrOffset_", declaredType="u_longlong_t")
	public UDATA puser_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._puser_spurrOffset_));
	}

	// u_longlong_t puser_spurr
	public UDATAPointer puser_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._puser_spurrOffset_));
	}

	// u_longlong_t pwait
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwaitOffset_", declaredType="u_longlong_t")
	public UDATA pwait() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._pwaitOffset_));
	}

	// u_longlong_t pwait
	public UDATAPointer pwaitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._pwaitOffset_));
	}

	// u_longlong_t pwait_spurr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pwait_spurrOffset_", declaredType="u_longlong_t")
	public UDATA pwait_spurr() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._pwait_spurrOffset_));
	}

	// u_longlong_t pwait_spurr
	public UDATAPointer pwait_spurrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._pwait_spurrOffset_));
	}

	// u_longlong_t readch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_readchOffset_", declaredType="u_longlong_t")
	public UDATA readch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._readchOffset_));
	}

	// u_longlong_t readch
	public UDATAPointer readchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._readchOffset_));
	}

	// u_longlong_t redisp_sd0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redisp_sd0Offset_", declaredType="u_longlong_t")
	public UDATA redisp_sd0() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._redisp_sd0Offset_));
	}

	// u_longlong_t redisp_sd0
	public UDATAPointer redisp_sd0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._redisp_sd0Offset_));
	}

	// u_longlong_t redisp_sd1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redisp_sd1Offset_", declaredType="u_longlong_t")
	public UDATA redisp_sd1() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._redisp_sd1Offset_));
	}

	// u_longlong_t redisp_sd1
	public UDATAPointer redisp_sd1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._redisp_sd1Offset_));
	}

	// u_longlong_t redisp_sd2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redisp_sd2Offset_", declaredType="u_longlong_t")
	public UDATA redisp_sd2() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._redisp_sd2Offset_));
	}

	// u_longlong_t redisp_sd2
	public UDATAPointer redisp_sd2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._redisp_sd2Offset_));
	}

	// u_longlong_t redisp_sd3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redisp_sd3Offset_", declaredType="u_longlong_t")
	public UDATA redisp_sd3() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._redisp_sd3Offset_));
	}

	// u_longlong_t redisp_sd3
	public UDATAPointer redisp_sd3EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._redisp_sd3Offset_));
	}

	// u_longlong_t redisp_sd4
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redisp_sd4Offset_", declaredType="u_longlong_t")
	public UDATA redisp_sd4() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._redisp_sd4Offset_));
	}

	// u_longlong_t redisp_sd4
	public UDATAPointer redisp_sd4EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._redisp_sd4Offset_));
	}

	// u_longlong_t redisp_sd5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redisp_sd5Offset_", declaredType="u_longlong_t")
	public UDATA redisp_sd5() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._redisp_sd5Offset_));
	}

	// u_longlong_t redisp_sd5
	public UDATAPointer redisp_sd5EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._redisp_sd5Offset_));
	}

	// u_longlong_t runque
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runqueOffset_", declaredType="u_longlong_t")
	public UDATA runque() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._runqueOffset_));
	}

	// u_longlong_t runque
	public UDATAPointer runqueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._runqueOffset_));
	}

	// u_longlong_t sema
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_semaOffset_", declaredType="u_longlong_t")
	public UDATA sema() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._semaOffset_));
	}

	// u_longlong_t sema
	public UDATAPointer semaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._semaOffset_));
	}

	// u_longlong_t softintrs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_softintrsOffset_", declaredType="u_longlong_t")
	public UDATA softintrs() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._softintrsOffset_));
	}

	// u_longlong_t softintrs
	public UDATAPointer softintrsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._softintrsOffset_));
	}

	// I32 spurrflag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spurrflagOffset_", declaredType="I32")
	public IDATA spurrflag() throws CorruptDataException {
		return new I32(getIntAtOffset(perfstat_cpu_t._spurrflagOffset_));
	}

	// I32 spurrflag
	public IDATAPointer spurrflagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._spurrflagOffset_));
	}

	// U8 state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stateOffset_", declaredType="U8")
	public U8 state() throws CorruptDataException {
		return new U8(getByteAtOffset(perfstat_cpu_t._stateOffset_));
	}

	// U8 state
	public U8Pointer stateEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(perfstat_cpu_t._stateOffset_));
	}

	// u_longlong_t sys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysOffset_", declaredType="u_longlong_t")
	public UDATA sys() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._sysOffset_));
	}

	// u_longlong_t sys
	public UDATAPointer sysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._sysOffset_));
	}

	// u_longlong_t syscall
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_syscallOffset_", declaredType="u_longlong_t")
	public UDATA syscall() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._syscallOffset_));
	}

	// u_longlong_t syscall
	public UDATAPointer syscallEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._syscallOffset_));
	}

	// u_longlong_t sysexec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysexecOffset_", declaredType="u_longlong_t")
	public UDATA sysexec() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._sysexecOffset_));
	}

	// u_longlong_t sysexec
	public UDATAPointer sysexecEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._sysexecOffset_));
	}

	// u_longlong_t sysfork
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysforkOffset_", declaredType="u_longlong_t")
	public UDATA sysfork() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._sysforkOffset_));
	}

	// u_longlong_t sysfork
	public UDATAPointer sysforkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._sysforkOffset_));
	}

	// u_longlong_t sysread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sysreadOffset_", declaredType="u_longlong_t")
	public UDATA sysread() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._sysreadOffset_));
	}

	// u_longlong_t sysread
	public UDATAPointer sysreadEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._sysreadOffset_));
	}

	// u_longlong_t syswrite
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_syswriteOffset_", declaredType="u_longlong_t")
	public UDATA syswrite() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._syswriteOffset_));
	}

	// u_longlong_t syswrite
	public UDATAPointer syswriteEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._syswriteOffset_));
	}

	// u_longlong_t tb_last
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tb_lastOffset_", declaredType="u_longlong_t")
	public UDATA tb_last() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._tb_lastOffset_));
	}

	// u_longlong_t tb_last
	public UDATAPointer tb_lastEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._tb_lastOffset_));
	}

	// u_longlong_t user
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_userOffset_", declaredType="u_longlong_t")
	public UDATA user() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._userOffset_));
	}

	// u_longlong_t user
	public UDATAPointer userEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._userOffset_));
	}

	// u_longlong_t version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="u_longlong_t")
	public UDATA version() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._versionOffset_));
	}

	// u_longlong_t version
	public UDATAPointer versionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._versionOffset_));
	}

	// u_longlong_t vol_cswitch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vol_cswitchOffset_", declaredType="u_longlong_t")
	public UDATA vol_cswitch() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._vol_cswitchOffset_));
	}

	// u_longlong_t vol_cswitch
	public UDATAPointer vol_cswitchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._vol_cswitchOffset_));
	}

	// u_longlong_t vtb_last
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vtb_lastOffset_", declaredType="u_longlong_t")
	public UDATA vtb_last() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._vtb_lastOffset_));
	}

	// u_longlong_t vtb_last
	public UDATAPointer vtb_lastEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._vtb_lastOffset_));
	}

	// u_longlong_t wait_field
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_wait_fieldOffset_", declaredType="u_longlong_t")
	public UDATA wait_field() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._wait_fieldOffset_));
	}

	// u_longlong_t wait_field
	public UDATAPointer wait_fieldEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._wait_fieldOffset_));
	}

	// u_longlong_t writech
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_writechOffset_", declaredType="u_longlong_t")
	public UDATA writech() throws CorruptDataException {
		return new U64(getLongAtOffset(perfstat_cpu_t._writechOffset_));
	}

	// u_longlong_t writech
	public UDATAPointer writechEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(perfstat_cpu_t._writechOffset_));
	}

}
