/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Intersection
extends AnimatingControlsSurface {
    private static final int HEIGHT_DECREASE = 0;
    private static final int HEIGHT_INCREASE = 1;
    private static final int WIDTH_DECREASE = 2;
    private static final int WIDTH_INCREASE = 3;
    private int xx;
    private int yy;
    private int ww;
    private int hh;
    private int direction = 0;
    private int angdeg;
    private Shape textshape;
    private double sw;
    private double sh;
    private GeneralPath ovals;
    private Rectangle2D rectshape;
    protected boolean doIntersection = true;
    protected boolean doOvals = true;
    protected boolean doText;
    protected boolean threeSixty;

    public Intersection() {
        this.setBackground(Color.WHITE);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void reset(int w, int h) {
        this.yy = 0;
        this.xx = 0;
        this.ww = w - 1;
        this.hh = h;
        this.direction = 0;
        this.angdeg = 0;
        FontRenderContext frc = new FontRenderContext(null, true, false);
        Font f = new Font("Serif", 1, 32);
        TextLayout tl = new TextLayout("J2D", f, frc);
        this.sw = tl.getBounds().getWidth();
        this.sh = tl.getBounds().getHeight();
        int size = Math.min(w, h);
        double sx = (double)(size - 40) / this.sw;
        double sy = (double)(size - 100) / this.sh;
        AffineTransform Tx = AffineTransform.getScaleInstance(sx, sy);
        this.textshape = tl.getOutline(Tx);
        this.rectshape = this.textshape.getBounds();
        this.sw = this.rectshape.getWidth();
        this.sh = this.rectshape.getHeight();
        this.ovals = new GeneralPath();
        this.ovals.append(new Ellipse2D.Double(10.0, 10.0, 20.0, 20.0), false);
        this.ovals.append(new Ellipse2D.Double(w - 30, 10.0, 20.0, 20.0), false);
        this.ovals.append(new Ellipse2D.Double(10.0, h - 30, 20.0, 20.0), false);
        this.ovals.append(new Ellipse2D.Double(w - 30, h - 30, 20.0, 20.0), false);
    }

    @Override
    public void step(int w, int h) {
        if (this.direction == 0) {
            this.yy += 2;
            this.hh -= 4;
            if (this.yy >= h / 2) {
                this.direction = 1;
            }
        } else if (this.direction == 1) {
            this.yy -= 2;
            this.hh += 4;
            if (this.yy <= 0) {
                this.direction = 2;
                this.hh = h - 1;
                this.yy = 0;
            }
        }
        if (this.direction == 2) {
            this.xx += 2;
            this.ww -= 4;
            if (this.xx >= w / 2) {
                this.direction = 3;
            }
        } else if (this.direction == 3) {
            this.xx -= 2;
            this.ww += 4;
            if (this.xx <= 0) {
                this.direction = 0;
                this.ww = w - 1;
                this.xx = 0;
            }
        }
        if ((this.angdeg += 5) == 360) {
            this.angdeg = 0;
            this.threeSixty = true;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        Rectangle rect = new Rectangle(this.xx, this.yy, this.ww, this.hh);
        AffineTransform Tx = new AffineTransform();
        Tx.rotate(Math.toRadians(this.angdeg), w / 2, h / 2);
        Tx.translate((double)(w / 2) - this.sw / 2.0, this.sh + ((double)h - this.sh) / 2.0);
        GeneralPath path = new GeneralPath();
        if (this.doOvals) {
            path.append(this.ovals, false);
        }
        if (this.doText) {
            path.append(Tx.createTransformedShape(this.textshape), false);
        } else {
            path.append(Tx.createTransformedShape(this.rectshape), false);
        }
        if (this.doIntersection) {
            g2.clip(rect);
            g2.clip(path);
        }
        g2.setColor(Color.GREEN);
        g2.fill(rect);
        g2.setClip(new Rectangle(0, 0, w, h));
        g2.setColor(Color.LIGHT_GRAY);
        g2.draw(rect);
        g2.setColor(Color.BLACK);
        g2.draw(path);
    }

    public static void main(String[] argv) {
        Intersection.createDemoFrame(new Intersection());
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        Intersection demo;
        JToolBar toolbar;

        public DemoControls(Intersection demo) {
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Intersect", true);
            this.addTool("Text", false);
            this.addTool("Ovals", true);
        }

        public void addTool(String str, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            if (b.getText().equals("Intersect")) {
                this.demo.doIntersection = b.isSelected();
            } else if (b.getText().equals("Ovals")) {
                this.demo.doOvals = b.isSelected();
            } else if (b.getText().equals("Text")) {
                this.demo.doText = b.isSelected();
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                if (this.demo.threeSixty) {
                    ((AbstractButton)this.toolbar.getComponentAtIndex(1)).doClick();
                    this.demo.threeSixty = false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            this.thread = null;
        }
    }
}

