/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: fileidPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the fileidPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=fileid.class)
public class fileidPointer extends StructurePointer {

	// NULL
	public static final fileidPointer NULL = new fileidPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected fileidPointer(long address) {
		super(address);
	}

	public static fileidPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static fileidPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static fileidPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new fileidPointer(address);
	}

	public fileidPointer add(long count) {
		return fileidPointer.cast(address + (fileid.SIZEOF * count));
	}

	public fileidPointer add(Scalar count) {
		return add(count.longValue());
	}

	public fileidPointer addOffset(long offset) {
		return fileidPointer.cast(address + offset);
	}

	public fileidPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public fileidPointer sub(long count) {
		return fileidPointer.cast(address - (fileid.SIZEOF * count));
	}

	public fileidPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public fileidPointer subOffset(long offset) {
		return fileidPointer.cast(address - offset);
	}

	public fileidPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public fileidPointer untag(long mask) {
		return fileidPointer.cast(address & ~mask);
	}

	public fileidPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return fileid.SIZEOF;
	}

	// Implementation methods

	// uint_t fid_gen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fid_genOffset_", declaredType="uint_t")
	public UDATA fid_gen() throws CorruptDataException {
		return new U32(getIntAtOffset(fileid._fid_genOffset_));
	}

	// uint_t fid_gen
	public UDATAPointer fid_genEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(fileid._fid_genOffset_));
	}

	// ino32_t fid_ino
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fid_inoOffset_", declaredType="ino32_t")
	public UDATA fid_ino() throws CorruptDataException {
		return new U32(getIntAtOffset(fileid._fid_inoOffset_));
	}

	// ino32_t fid_ino
	public UDATAPointer fid_inoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(fileid._fid_inoOffset_));
	}

	// uint_t fid_len
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fid_lenOffset_", declaredType="uint_t")
	public UDATA fid_len() throws CorruptDataException {
		return new U32(getIntAtOffset(fileid._fid_lenOffset_));
	}

	// uint_t fid_len
	public UDATAPointer fid_lenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(fileid._fid_lenOffset_));
	}

	// U8[] fid_x
	public U8Pointer fid_xEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(fileid._fid_xOffset_));
	}

}
