/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: kernvarsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the kernvarsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=kernvars.class)
public class kernvarsPointer extends StructurePointer {

	// NULL
	public static final kernvarsPointer NULL = new kernvarsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected kernvarsPointer(long address) {
		super(address);
	}

	public static kernvarsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static kernvarsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static kernvarsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new kernvarsPointer(address);
	}

	public kernvarsPointer add(long count) {
		return kernvarsPointer.cast(address + (kernvars.SIZEOF * count));
	}

	public kernvarsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public kernvarsPointer addOffset(long offset) {
		return kernvarsPointer.cast(address + offset);
	}

	public kernvarsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public kernvarsPointer sub(long count) {
		return kernvarsPointer.cast(address - (kernvars.SIZEOF * count));
	}

	public kernvarsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public kernvarsPointer subOffset(long offset) {
		return kernvarsPointer.cast(address - offset);
	}

	public kernvarsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public kernvarsPointer untag(long mask) {
		return kernvarsPointer.cast(address & ~mask);
	}

	public kernvarsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return kernvars.SIZEOF;
	}

	// Implementation methods

	// I64 v_acl_config
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_acl_configOffset_", declaredType="I64")
	public IDATA v_acl_config() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_acl_configOffset_));
	}

	// I64 v_acl_config
	public IDATAPointer v_acl_configEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_acl_configOffset_));
	}

	// I32 v_autost
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_autostOffset_", declaredType="I32")
	public IDATA v_autost() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_autostOffset_));
	}

	// I32 v_autost
	public IDATAPointer v_autostEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_autostOffset_));
	}

	// I64 v_bufhw
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_bufhwOffset_", declaredType="I64")
	public IDATA v_bufhw() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_bufhwOffset_));
	}

	// I64 v_bufhw
	public IDATAPointer v_bufhwEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_bufhwOffset_));
	}

	// I32 v_chown_restrict
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_chown_restrictOffset_", declaredType="I32")
	public IDATA v_chown_restrict() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_chown_restrictOffset_));
	}

	// I32 v_chown_restrict
	public IDATAPointer v_chown_restrictEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_chown_restrictOffset_));
	}

	// I64 v_clist
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_clistOffset_", declaredType="I64")
	public IDATA v_clist() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_clistOffset_));
	}

	// I64 v_clist
	public IDATAPointer v_clistEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_clistOffset_));
	}

	// I32 v_cluster_aware
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_cluster_awareOffset_", declaredType="I32")
	public IDATA v_cluster_aware() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_cluster_awareOffset_));
	}

	// I32 v_cluster_aware
	public IDATAPointer v_cluster_awareEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_cluster_awareOffset_));
	}

	// I32 v_coreformat
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_coreformatOffset_", declaredType="I32")
	public IDATA v_coreformat() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_coreformatOffset_));
	}

	// I32 v_coreformat
	public IDATAPointer v_coreformatEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_coreformatOffset_));
	}

	// I32 v_cpuguard
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_cpuguardOffset_", declaredType="I32")
	public IDATA v_cpuguard() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_cpuguardOffset_));
	}

	// I32 v_cpuguard
	public IDATAPointer v_cpuguardEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_cpuguardOffset_));
	}

	// I64 v_enhanced_rbac
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_enhanced_rbacOffset_", declaredType="I64")
	public IDATA v_enhanced_rbac() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_enhanced_rbacOffset_));
	}

	// I64 v_enhanced_rbac
	public IDATAPointer v_enhanced_rbacEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_enhanced_rbacOffset_));
	}

	// I64 v_file
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_fileOffset_", declaredType="I64")
	public IDATA v_file() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_fileOffset_));
	}

	// I64 v_file
	public IDATAPointer v_fileEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_fileOffset_));
	}

	// I64 v_file_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_file_maxOffset_", declaredType="I64")
	public IDATA v_file_max() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_file_maxOffset_));
	}

	// I64 v_file_max
	public IDATAPointer v_file_maxEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_file_maxOffset_));
	}

	// I32 v_fullcore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_fullcoreOffset_", declaredType="I32")
	public IDATA v_fullcore() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_fullcoreOffset_));
	}

	// I32 v_fullcore
	public IDATAPointer v_fullcoreEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_fullcoreOffset_));
	}

	// I64 v_hardstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_hardstackOffset_", declaredType="I64")
	public IDATA v_hardstack() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_hardstackOffset_));
	}

	// I64 v_hardstack
	public IDATAPointer v_hardstackEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_hardstackOffset_));
	}

	// U8[] v_initlvl
	public U8Pointer v_initlvlEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(kernvars._v_initlvlOffset_));
	}

	// I32 v_iostrun
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_iostrunOffset_", declaredType="I32")
	public IDATA v_iostrun() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_iostrunOffset_));
	}

	// I32 v_iostrun
	public IDATAPointer v_iostrunEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_iostrunOffset_));
	}

	// I32 v_leastpriv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_leastprivOffset_", declaredType="I32")
	public IDATA v_leastpriv() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_leastprivOffset_));
	}

	// I32 v_leastpriv
	public IDATAPointer v_leastprivEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_leastprivOffset_));
	}

	// I64 v_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_lockOffset_", declaredType="I64")
	public IDATA v_lock() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_lockOffset_));
	}

	// I64 v_lock
	public IDATAPointer v_lockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_lockOffset_));
	}

	// I64 v_lock_max
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_lock_maxOffset_", declaredType="I64")
	public IDATA v_lock_max() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_lock_maxOffset_));
	}

	// I64 v_lock_max
	public IDATAPointer v_lock_maxEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_lock_maxOffset_));
	}

	// I32 v_max_logname
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_max_lognameOffset_", declaredType="I32")
	public IDATA v_max_logname() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_max_lognameOffset_));
	}

	// I32 v_max_logname
	public IDATAPointer v_max_lognameEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_max_lognameOffset_));
	}

	// I64 v_maxpout
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_maxpoutOffset_", declaredType="I64")
	public IDATA v_maxpout() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_maxpoutOffset_));
	}

	// I64 v_maxpout
	public IDATAPointer v_maxpoutEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_maxpoutOffset_));
	}

	// I64 v_maxup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_maxupOffset_", declaredType="I64")
	public IDATA v_maxup() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_maxupOffset_));
	}

	// I64 v_maxup
	public IDATAPointer v_maxupEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_maxupOffset_));
	}

	// I64 v_mbufhw
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_mbufhwOffset_", declaredType="I64")
	public IDATA v_mbufhw() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_mbufhwOffset_));
	}

	// I64 v_mbufhw
	public IDATAPointer v_mbufhwEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_mbufhwOffset_));
	}

	// I32 v_memscrub
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_memscrubOffset_", declaredType="I32")
	public IDATA v_memscrub() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_memscrubOffset_));
	}

	// I32 v_memscrub
	public IDATAPointer v_memscrubEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_memscrubOffset_));
	}

	// I64 v_minpout
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_minpoutOffset_", declaredType="I64")
	public IDATA v_minpout() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_minpoutOffset_));
	}

	// I64 v_minpout
	public IDATAPointer v_minpoutEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_minpoutOffset_));
	}

	// I32 v_ncargs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncargsOffset_", declaredType="I32")
	public IDATA v_ncargs() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_ncargsOffset_));
	}

	// I32 v_ncargs
	public IDATAPointer v_ncargsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_ncargsOffset_));
	}

	// I32 v_ncpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncpusOffset_", declaredType="I32")
	public IDATA v_ncpus() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_ncpusOffset_));
	}

	// I32 v_ncpus
	public IDATAPointer v_ncpusEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_ncpusOffset_));
	}

	// I32 v_ncpus_cfg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ncpus_cfgOffset_", declaredType="I32")
	public IDATA v_ncpus_cfg() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_ncpus_cfgOffset_));
	}

	// I32 v_ncpus_cfg
	public IDATAPointer v_ncpus_cfgEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_ncpus_cfgOffset_));
	}

	// I32 v_ngroups_allowed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_ngroups_allowedOffset_", declaredType="I32")
	public IDATA v_ngroups_allowed() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_ngroups_allowedOffset_));
	}

	// I32 v_ngroups_allowed
	public IDATAPointer v_ngroups_allowedEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_ngroups_allowedOffset_));
	}

	// I32 v_num_xmfrecs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_num_xmfrecsOffset_", declaredType="I32")
	public IDATA v_num_xmfrecs() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_num_xmfrecsOffset_));
	}

	// I32 v_num_xmfrecs
	public IDATAPointer v_num_xmfrecsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_num_xmfrecsOffset_));
	}

	// I32 v_pmu_access
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_pmu_accessOffset_", declaredType="I32")
	public IDATA v_pmu_access() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_pmu_accessOffset_));
	}

	// I32 v_pmu_access
	public IDATAPointer v_pmu_accessEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_pmu_accessOffset_));
	}

	// I32 v_pre520tune
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_pre520tuneOffset_", declaredType="I32")
	public IDATA v_pre520tune() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_pre520tuneOffset_));
	}

	// I32 v_pre520tune
	public IDATAPointer v_pre520tuneEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_pre520tuneOffset_));
	}

	// I64 v_proc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_procOffset_", declaredType="I64")
	public IDATA v_proc() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_procOffset_));
	}

	// I64 v_proc
	public IDATAPointer v_procEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_procOffset_));
	}

	// I64 v_sed_config
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_sed_configOffset_", declaredType="I64")
	public IDATA v_sed_config() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_sed_configOffset_));
	}

	// I64 v_sed_config
	public IDATAPointer v_sed_configEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_sed_configOffset_));
	}

	// I64 v_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_threadOffset_", declaredType="I64")
	public IDATA v_thread() throws CorruptDataException {
		return new I64(getLongAtOffset(kernvars._v_threadOffset_));
	}

	// I64 v_thread
	public IDATAPointer v_threadEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_threadOffset_));
	}

	// I32 v_xmdbg_segs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_xmdbg_segsOffset_", declaredType="I32")
	public IDATA v_xmdbg_segs() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_xmdbg_segsOffset_));
	}

	// I32 v_xmdbg_segs
	public IDATAPointer v_xmdbg_segsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_xmdbg_segsOffset_));
	}

	// I32 v_xmgc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_v_xmgcOffset_", declaredType="I32")
	public IDATA v_xmgc() throws CorruptDataException {
		return new I32(getIntAtOffset(kernvars._v_xmgcOffset_));
	}

	// I32 v_xmgc
	public IDATAPointer v_xmgcEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(kernvars._v_xmgcOffset_));
	}

	// var_hdr var_hdr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_var_hdrOffset_", declaredType="var_hdr")
	public var_hdrPointer var_hdr() throws CorruptDataException {
		return var_hdrPointer.cast(nonNullFieldEA(kernvars._var_hdrOffset_));
	}

	// var_hdr var_hdr
	public PointerPointer var_hdrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._var_hdrOffset_));
	}

	// __cptr64 vb_proc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vb_procOffset_", declaredType="__cptr64")
	public U8Pointer vb_proc() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(kernvars._vb_procOffset_));
	}

	// __cptr64 vb_proc
	public PointerPointer vb_procEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._vb_procOffset_));
	}

	// __cptr64 vb_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vb_threadOffset_", declaredType="__cptr64")
	public U8Pointer vb_thread() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(kernvars._vb_threadOffset_));
	}

	// __cptr64 vb_thread
	public PointerPointer vb_threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._vb_threadOffset_));
	}

	// __cptr64 ve_file
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_fileOffset_", declaredType="__cptr64")
	public U8Pointer ve_file() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(kernvars._ve_fileOffset_));
	}

	// __cptr64 ve_file
	public PointerPointer ve_fileEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._ve_fileOffset_));
	}

	// __cptr64 ve_lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_lockOffset_", declaredType="__cptr64")
	public U8Pointer ve_lock() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(kernvars._ve_lockOffset_));
	}

	// __cptr64 ve_lock
	public PointerPointer ve_lockEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._ve_lockOffset_));
	}

	// __cptr64 ve_proc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_procOffset_", declaredType="__cptr64")
	public U8Pointer ve_proc() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(kernvars._ve_procOffset_));
	}

	// __cptr64 ve_proc
	public PointerPointer ve_procEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._ve_procOffset_));
	}

	// __cptr64 ve_thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ve_threadOffset_", declaredType="__cptr64")
	public U8Pointer ve_thread() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(kernvars._ve_threadOffset_));
	}

	// __cptr64 ve_thread
	public PointerPointer ve_threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(kernvars._ve_threadOffset_));
	}

}
