/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: pce_idPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the pce_idPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=pce_id.class)
public class pce_idPointer extends StructurePointer {

	// NULL
	public static final pce_idPointer NULL = new pce_idPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected pce_idPointer(long address) {
		super(address);
	}

	public static pce_idPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static pce_idPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static pce_idPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new pce_idPointer(address);
	}

	public pce_idPointer add(long count) {
		return pce_idPointer.cast(address + (pce_id.SIZEOF * count));
	}

	public pce_idPointer add(Scalar count) {
		return add(count.longValue());
	}

	public pce_idPointer addOffset(long offset) {
		return pce_idPointer.cast(address + offset);
	}

	public pce_idPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public pce_idPointer sub(long count) {
		return pce_idPointer.cast(address - (pce_id.SIZEOF * count));
	}

	public pce_idPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public pce_idPointer subOffset(long offset) {
		return pce_idPointer.cast(address - offset);
	}

	public pce_idPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public pce_idPointer untag(long mask) {
		return pce_idPointer.cast(address & ~mask);
	}

	public pce_idPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return pce_id.SIZEOF;
	}

	// Implementation methods

	// I32[] id_data
	public IDATAPointer id_dataEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(pce_id._id_dataOffset_));
	}

	// U16 id_len
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_id_lenOffset_", declaredType="U16")
	public U16 id_len() throws CorruptDataException {
		return new U16(getShortAtOffset(pce_id._id_lenOffset_));
	}

	// U16 id_len
	public U16Pointer id_lenEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pce_id._id_lenOffset_));
	}

	// U16 id_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_id_typeOffset_", declaredType="U16")
	public U16 id_type() throws CorruptDataException {
		return new U16(getShortAtOffset(pce_id._id_typeOffset_));
	}

	// U16 id_type
	public U16Pointer id_typeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(pce_id._id_typeOffset_));
	}

}
