/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: VM_JFRChunkWriter
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class VM_JFRChunkWriter {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __bufferWriterOffset_;
	public static final int __buildResultOffset_;
	public static final int __checkPointEventOffsetOffset_;
	public static final int __constantPoolTypesOffset_;
	public static final int __currentFrameCountOffset_;
	public static final int __currentStackFrameBufferOffset_;
	public static final int __currentThreadOffset_;
	public static final int __debugOffset_;
	public static final int __finalWriteOffset_;
	public static final int __firstStackTraceEntryOffset_;
	public static final int __globalStringTableOffset_;
	public static final int __jfrHeaderCursorOffset_;
	public static final int __lastDataStartOffset_;
	public static final int __metadataOffsetOffset_;
	public static final int __previousCheckpointDeltaOffset_;
	public static final int __previousStackTraceEntryOffset_;
	public static final int __vmOffset_;
	public static final int _privatePortLibraryOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__bufferWriterOffset_ = 0;
		__buildResultOffset_ = 0;
		__checkPointEventOffsetOffset_ = 0;
		__constantPoolTypesOffset_ = 0;
		__currentFrameCountOffset_ = 0;
		__currentStackFrameBufferOffset_ = 0;
		__currentThreadOffset_ = 0;
		__debugOffset_ = 0;
		__finalWriteOffset_ = 0;
		__firstStackTraceEntryOffset_ = 0;
		__globalStringTableOffset_ = 0;
		__jfrHeaderCursorOffset_ = 0;
		__lastDataStartOffset_ = 0;
		__metadataOffsetOffset_ = 0;
		__previousCheckpointDeltaOffset_ = 0;
		__previousStackTraceEntryOffset_ = 0;
		__vmOffset_ = 0;
		_privatePortLibraryOffset_ = 0;
	}

}
